/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DynamicRouter;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.RouteContext;

public class DynamicRouterReifier
extends ExpressionReifier<DynamicRouterDefinition<?>> {
    public DynamicRouterReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (ExpressionNode)DynamicRouterDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Expression expression = this.createExpression(((DynamicRouterDefinition)this.definition).getExpression());
        String delimiter = ((DynamicRouterDefinition)this.definition).getUriDelimiter() != null ? ((DynamicRouterDefinition)this.definition).getUriDelimiter() : ",";
        DynamicRouter dynamicRouter = new DynamicRouter(this.camelContext, expression, delimiter);
        if (((DynamicRouterDefinition)this.definition).getIgnoreInvalidEndpoints() != null) {
            dynamicRouter.setIgnoreInvalidEndpoints(this.parseBoolean(((DynamicRouterDefinition)this.definition).getIgnoreInvalidEndpoints(), false));
        }
        if (((DynamicRouterDefinition)this.definition).getCacheSize() != null) {
            dynamicRouter.setCacheSize(this.parseInt(((DynamicRouterDefinition)this.definition).getCacheSize()).intValue());
        }
        ErrorHandlerFactory builder = this.routeContext.getErrorHandlerFactory();
        AsyncProcessor errorHandler = (AsyncProcessor)ErrorHandlerReifier.reifier(this.routeContext, builder).createErrorHandler((Processor)dynamicRouter.newRoutingSlipProcessorForErrorHandler());
        dynamicRouter.setErrorHandler(errorHandler);
        return dynamicRouter;
    }
}

