/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.compaction;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.compaction.CompactionManager;
import io.atomix.copycat.server.storage.compaction.CompactionTask;
import io.atomix.copycat.server.storage.compaction.Compactor;
import io.atomix.copycat.server.storage.compaction.MajorCompactionTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MajorCompactionManager
implements CompactionManager {
    private final Compactor compactor;

    MajorCompactionManager(Compactor compactor) {
        this.compactor = (Compactor)Assert.notNull((Object)compactor, (String)"compactor");
    }

    public List<CompactionTask> buildTasks(Storage storage, SegmentManager segments) {
        List<List<Segment>> groups = this.getCompactableGroups(storage, segments);
        return !groups.isEmpty() ? Collections.singletonList(new MajorCompactionTask(segments, groups, this.compactor.snapshotIndex(), this.compactor.majorIndex(), this.compactor.getDefaultCompactionMode())) : Collections.emptyList();
    }

    public List<List<Segment>> getCompactableGroups(Storage storage, SegmentManager manager) {
        ArrayList<List<Segment>> compact = new ArrayList<List<Segment>>();
        ArrayList<Segment> segments = null;
        for (Segment segment : this.getCompactableSegments(manager)) {
            if (segments == null) {
                segments = new ArrayList<Segment>();
                segments.add(segment);
                continue;
            }
            if (segments.stream().mapToLong(Segment::size).sum() + segment.size() <= (long)storage.maxSegmentSize() && segments.stream().mapToLong(Segment::count).sum() + (long)segment.count() <= (long)storage.maxEntriesPerSegment()) {
                segments.add(segment);
                continue;
            }
            compact.add(segments);
            segments = new ArrayList();
            segments.add(segment);
        }
        if (segments != null) {
            compact.add(segments);
        }
        return compact;
    }

    private List<Segment> getCompactableSegments(SegmentManager manager) {
        ArrayList<Segment> segments = new ArrayList<Segment>(manager.segments().size());
        Iterator<Segment> iterator = manager.segments().iterator();
        Segment segment = iterator.next();
        while (iterator.hasNext()) {
            Segment nextSegment = iterator.next();
            if (!segment.isCompacted() && (!segment.isFull() || segment.lastIndex() >= this.compactor.minorIndex() || nextSegment.firstIndex() > manager.commitIndex() || nextSegment.isEmpty())) break;
            segments.add(segment);
            segment = nextSegment;
        }
        return segments;
    }
}

