/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.util;

import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.Durations;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;

public final class PropertiesReader {
    private final Properties properties;

    public static PropertiesReader load(String propertiesFile) {
        return new PropertiesReader(PropertiesReader.loadProperties(propertiesFile));
    }

    public static PropertiesReader loadFromClasspath(String propertiesFile) {
        return new PropertiesReader(PropertiesReader.loadPropertiesFromClasspath(propertiesFile));
    }

    private static Properties loadProperties(String propertiesFile) {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(propertiesFile);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load properties", e);
        }
        return properties;
    }

    private static Properties loadPropertiesFromClasspath(String propertiesFile) {
        Properties properties = new Properties();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFile);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load properties", e);
        }
        return properties;
    }

    public PropertiesReader(Properties properties) {
        this.properties = Assert.notNull(properties, "properties");
    }

    public Properties properties() {
        return this.properties;
    }

    public <T> Collection<T> getCollection(String prefix, Function<String, T> factory) {
        ArrayList<T> collection = new ArrayList<T>();
        for (String property : this.properties.stringPropertyNames()) {
            if (!property.startsWith(prefix + ".")) continue;
            collection.add(factory.apply(property));
        }
        return collection;
    }

    public <K, V> Map<K, V> getMap(String prefix, Function<String, K> keyFactory, Function<String, V> valueFactory) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (String property : this.properties.stringPropertyNames()) {
            if (!property.startsWith(prefix + ".")) continue;
            map.put(keyFactory.apply(property.substring(prefix.length() + 1)), valueFactory.apply(this.properties.getProperty(property)));
        }
        return map;
    }

    public Class<?> getClass(String property) {
        return this.getProperty(property, className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("unknown class: " + className, new Object[]{e});
            }
        });
    }

    public Class<?> getClass(String property, Class<?> defaultValue) {
        return this.getProperty(property, defaultValue, className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("unknown class: " + className, new Object[]{e});
            }
        });
    }

    public File getFile(String property) {
        return this.getProperty(property, File::new);
    }

    public File getFile(String property, File defaultValue) {
        return this.getProperty(property, defaultValue, File::new);
    }

    public <T extends Enum<T>> T getEnum(String property, Class<T> type) {
        return Enum.valueOf(type, this.getString(property));
    }

    public <T extends Enum<T>> T getEnum(String property, Class<T> type, T defaultValue) {
        return Enum.valueOf(type, this.getString(property, defaultValue.name()));
    }

    public String getString(String property) {
        return this.getProperty(property, v -> v);
    }

    public String getString(String property, String defaultValue) {
        return this.getProperty(property, defaultValue, v -> v);
    }

    public boolean getBoolean(String property) {
        return this.getProperty(property, value -> {
            switch (value.trim().toLowerCase()) {
                case "true": 
                case "1": {
                    return true;
                }
                case "false": 
                case "0": {
                    return false;
                }
            }
            throw new ConfigurationException("invalid property value: " + property + " must be a boolean", new Object[0]);
        });
    }

    public boolean getBoolean(String property, boolean defaultValue) {
        return this.getProperty(property, defaultValue, value -> {
            switch (value.trim().toLowerCase()) {
                case "true": 
                case "1": {
                    return true;
                }
                case "false": 
                case "0": {
                    return false;
                }
            }
            throw new ConfigurationException("invalid property value: " + property + " must be a boolean", new Object[0]);
        });
    }

    public short getShort(String property) {
        return this.getProperty(property, value -> {
            try {
                return Short.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a short", new Object[0]);
            }
        });
    }

    public short getShort(String property, short defaultValue) {
        return this.getProperty(property, defaultValue, value -> {
            try {
                return Short.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a short", new Object[0]);
            }
        });
    }

    public int getInteger(String property) {
        return this.getProperty(property, value -> {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be an integer", new Object[0]);
            }
        });
    }

    public int getInteger(String property, int defaultValue) {
        return this.getProperty(property, defaultValue, value -> {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be an integer", new Object[0]);
            }
        });
    }

    public long getLong(String property) {
        return this.getProperty(property, value -> {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a long", new Object[0]);
            }
        });
    }

    public long getLong(String property, long defaultValue) {
        return this.getProperty(property, defaultValue, value -> {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a long", new Object[0]);
            }
        });
    }

    public float getFloat(String property) {
        return this.getProperty(property, value -> {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a float", new Object[0]);
            }
        }).floatValue();
    }

    public float getFloat(String property, float defaultValue) {
        return this.getProperty(property, Float.valueOf(defaultValue), value -> {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a float", new Object[0]);
            }
        }).floatValue();
    }

    public double getDouble(String property) {
        return this.getProperty(property, value -> {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a double", new Object[0]);
            }
        });
    }

    public double getDouble(String property, double defaultValue) {
        return this.getProperty(property, defaultValue, value -> {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a double", new Object[0]);
            }
        });
    }

    public Duration getDuration(String property) {
        return this.getProperty(property, value -> {
            try {
                return Duration.ofMillis(Long.valueOf(value));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a number", new Object[0]);
            }
        });
    }

    public Duration getDuration(String property, Duration defaultValue) {
        return this.getProperty(property, defaultValue, value -> {
            try {
                return Durations.of(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("malformed property value: " + property + " must be a number", new Object[0]);
            }
        });
    }

    private <T> T getProperty(String property, Function<String, T> transformer) {
        Assert.notNull(property, "property");
        String value = this.properties.getProperty(property);
        if (value == null) {
            throw new ConfigurationException("missing property: " + property, new Object[0]);
        }
        return transformer.apply(value);
    }

    private <T> T getProperty(String property, T defaultValue, Function<String, T> transformer) {
        Assert.notNull(property, "property");
        String value = this.properties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return transformer.apply(value);
    }
}

