/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport.netty;

import io.atomix.catalyst.concurrent.CatalystThreadFactory;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.transport.netty.NettyClient;
import io.atomix.catalyst.transport.netty.NettyOptions;
import io.atomix.catalyst.transport.netty.NettyServer;
import io.atomix.catalyst.transport.netty.SslProtocol;
import io.atomix.catalyst.util.Assert;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;

public class NettyTransport
implements Transport {
    private final NettyOptions properties;
    private final EventLoopGroup eventLoopGroup;

    public static Builder builder() {
        return new Builder();
    }

    public NettyTransport() {
        this(new NettyOptions(new Properties()));
    }

    public NettyTransport(Properties properties) {
        this(new NettyOptions(properties));
    }

    public NettyTransport(NettyOptions properties) {
        this.properties = (NettyOptions)Assert.notNull((Object)properties, (String)"properties");
        CatalystThreadFactory threadFactory = new CatalystThreadFactory("catalyst-event-loop-%d");
        this.eventLoopGroup = new NioEventLoopGroup(properties.threads(), (ThreadFactory)threadFactory);
    }

    public NettyOptions properties() {
        return this.properties;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public Client client() {
        return new NettyClient(this);
    }

    public Server server() {
        return new NettyServer(this);
    }

    public void close() {
        try {
            this.eventLoopGroup.shutdownGracefully().sync();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class Builder
    implements Transport.Builder {
        private final Properties properties = new Properties();

        private Builder() {
        }

        public Builder withThreads(int threads) {
            this.properties.setProperty("threads", String.valueOf(Assert.argNot((Object)threads, (threads <= 0 ? 1 : 0) != 0, (String)"threads must be positive", (Object[])new Object[0])));
            return this;
        }

        public Builder withConnectTimeout(int timeout) {
            this.properties.setProperty("connectTimeout", String.valueOf(Assert.argNot((Object)timeout, (timeout <= 0 ? 1 : 0) != 0, (String)"timeout must be positive", (Object[])new Object[0])));
            return this;
        }

        public Builder withSendBufferSize(int sendBufferSize) {
            this.properties.setProperty("sendBufferSize", String.valueOf(Assert.argNot((Object)sendBufferSize, (sendBufferSize <= 0 ? 1 : 0) != 0, (String)"buffer size must be positive", (Object[])new Object[0])));
            return this;
        }

        public Builder withReceiveBufferSize(int receiveBufferSize) {
            this.properties.setProperty("receiveBufferSize", String.valueOf(Assert.argNot((Object)receiveBufferSize, (receiveBufferSize <= 0 ? 1 : 0) != 0, (String)"buffer size must be positive", (Object[])new Object[0])));
            return this;
        }

        public Builder withMaxFrameSize(int maxFrameSize) {
            this.properties.setProperty("maxFrameSize", String.valueOf(Assert.argNot((Object)maxFrameSize, (maxFrameSize <= 0 ? 1 : 0) != 0, (String)"maximum frame size must be positive", (Object[])new Object[0])));
            return this;
        }

        public Builder withReuseAddress() {
            return this.withReuseAddress(true);
        }

        public Builder withReuseAddress(boolean reuseAddress) {
            this.properties.setProperty("reuseAddress", String.valueOf(reuseAddress));
            return this;
        }

        public Builder withTcpKeepAlive() {
            return this.withTcpKeepAlive(true);
        }

        public Builder withTcpKeepAlive(boolean tcpKeepAlive) {
            this.properties.setProperty("tcpKeepAlive", String.valueOf(tcpKeepAlive));
            return this;
        }

        public Builder withTcpNoDelay() {
            return this.withTcpNoDelay(true);
        }

        public Builder withTcpNoDelay(boolean tcpNoDelay) {
            this.properties.setProperty("tcpNoDelay", String.valueOf(tcpNoDelay));
            return this;
        }

        public Builder withAcceptBacklog(int acceptBacklog) {
            this.properties.setProperty("acceptBacklog", String.valueOf(Assert.argNot((Object)acceptBacklog, (acceptBacklog <= 0 ? 1 : 0) != 0, (String)"accept backlog must be positive", (Object[])new Object[0])));
            return this;
        }

        public Builder withRequestTimeout(int requestTimeout) {
            this.properties.setProperty("requestTimeout", String.valueOf(Assert.argNot((Object)requestTimeout, (requestTimeout <= 0 ? 1 : 0) != 0, (String)"request timeout must be positive", (Object[])new Object[0])));
            return this;
        }

        public Builder withSsl() {
            return this.withSsl(true);
        }

        public Builder withSsl(boolean sslEnabled) {
            this.properties.setProperty("ssl.enabled", String.valueOf(sslEnabled));
            return this;
        }

        public Builder withSslProtocol(SslProtocol sslProtocol) {
            this.properties.setProperty("ssl.protocol", ((SslProtocol)((Object)Assert.notNull((Object)((Object)sslProtocol), (String)"sslProtocol"))).name().replace("_", "."));
            return this;
        }

        public Builder withTrustStorePath(String trustStorePath) {
            this.properties.setProperty("ssl.trustStore.path", (String)Assert.notNull((Object)trustStorePath, (String)"trustStorePath"));
            return this;
        }

        public Builder withTrustStorePassword(String trustStorePassword) {
            this.properties.setProperty("ssl.trustStore.password", (String)Assert.notNull((Object)trustStorePassword, (String)"trustStorePassword"));
            return this;
        }

        public Builder withKeyStorePath(String keyStorePath) {
            this.properties.setProperty("ssl.keyStore.path", (String)Assert.notNull((Object)keyStorePath, (String)"keyStorePath"));
            return this;
        }

        public Builder withKeyStorePassword(String trustStorePassword) {
            this.properties.setProperty("ssl.keyStore.password", (String)Assert.notNull((Object)trustStorePassword, (String)"trustStorePassword"));
            return this;
        }

        public Builder withKeyStoreKeyPassword(String keyStoreKeyPassword) {
            this.properties.setProperty("ssl.keyStore.keyPassword", (String)Assert.notNull((Object)keyStoreKeyPassword, (String)"trustStorePassword"));
            return this;
        }

        public Transport build() {
            return new NettyTransport(this.properties);
        }
    }
}

