/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.util;

import io.atomix.catalyst.util.Assert;
import java.util.Properties;

public class QualifiedProperties
extends Properties {
    private final String qualifier;

    public QualifiedProperties(String qualifier) {
        this.qualifier = Assert.notNull(qualifier, "qualifier");
    }

    public QualifiedProperties(Properties defaults, String qualifier) {
        super(defaults);
        this.qualifier = defaults instanceof QualifiedProperties ? String.format("%s.%s", ((QualifiedProperties)defaults).qualifier, qualifier) : Assert.notNull(qualifier, "qualifier");
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(String.format("%s.%s", this.qualifier, key), value);
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(String.format("%s.%s", this.qualifier, key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(String.format("%s.%s", this.qualifier, key), defaultValue);
    }
}

