/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.Listeners;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.PublishRequest;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.state.ServerStateMachine;
import io.atomix.copycat.server.state.ServerStateMachineContext;
import io.atomix.copycat.server.storage.Log;
import io.atomix.copycat.session.Event;
import io.atomix.copycat.session.Session;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerSessionContext
implements ServerSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSessionContext.class);
    private final long id;
    private final String client;
    private final Log log;
    private final ServerStateMachineContext context;
    private boolean open;
    private volatile Session.State state = Session.State.OPEN;
    private final long timeout;
    private Connection connection;
    private volatile long references;
    private long keepAliveIndex;
    private long requestSequence;
    private long commandSequence;
    private long lastApplied;
    private long commandLowWaterMark;
    private long eventIndex;
    private long completeIndex;
    private long closeIndex;
    private long timestamp;
    private final Map<Long, List<Runnable>> sequenceQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, List<Runnable>> indexQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, ServerStateMachine.Result> results = new HashMap<Long, ServerStateMachine.Result>();
    private final Queue<EventHolder> events = new LinkedList<EventHolder>();
    private EventHolder event;
    private boolean unregistering;
    private final Listeners<Session.State> changeListeners = new Listeners();

    ServerSessionContext(long id, String client, Log log, ServerStateMachineContext context, long timeout) {
        this.id = id;
        this.client = (String)Assert.notNull((Object)client, (String)"client");
        this.log = (Log)Assert.notNull((Object)log, (String)"log");
        this.eventIndex = id;
        this.completeIndex = id;
        this.lastApplied = id - 1L;
        this.context = context;
        this.timeout = timeout;
    }

    public long id() {
        return this.id;
    }

    public String client() {
        return this.client;
    }

    void open() {
        this.open = true;
    }

    public Session.State state() {
        return this.state;
    }

    private void setState(Session.State state) {
        if (this.state != state) {
            this.state = state;
            LOGGER.debug("{} - State changed: {}", (Object)this.id, (Object)state);
            this.changeListeners.forEach(l -> l.accept((Object)state));
        }
    }

    public Listener<Session.State> onStateChange(Consumer<Session.State> callback) {
        return this.changeListeners.add(callback);
    }

    void acquire() {
        ++this.references;
    }

    void release() {
        long references = --this.references;
        if (!this.state.active() && references == 0L) {
            this.context.sessions().unregisterSession(this.id);
            this.log.release(this.id);
            if (this.closeIndex > 0L) {
                this.log.release(this.closeIndex);
            }
        }
    }

    long references() {
        return this.references;
    }

    long timeout() {
        return this.timeout;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    ServerSessionContext setTimestamp(long timestamp) {
        this.timestamp = Math.max(this.timestamp, timestamp);
        return this;
    }

    long getKeepAliveIndex() {
        return this.keepAliveIndex;
    }

    ServerSessionContext setKeepAliveIndex(long keepAliveIndex) {
        long previousKeepAliveIndex = this.keepAliveIndex;
        this.keepAliveIndex = keepAliveIndex;
        if (previousKeepAliveIndex > 0L) {
            this.log.release(previousKeepAliveIndex);
        }
        return this;
    }

    long getRequestSequence() {
        return this.requestSequence;
    }

    boolean setRequestSequence(long requestSequence) {
        if (requestSequence == this.requestSequence + 1L) {
            this.requestSequence = requestSequence;
            return true;
        }
        return requestSequence <= this.requestSequence;
    }

    ServerSessionContext resetRequestSequence(long requestSequence) {
        if (requestSequence > this.requestSequence) {
            this.requestSequence = requestSequence;
        }
        return this;
    }

    long getCommandSequence() {
        return this.commandSequence;
    }

    long nextCommandSequence() {
        return this.commandSequence + 1L;
    }

    ServerSessionContext setCommandSequence(long sequence) {
        for (long i = this.commandSequence + 1L; i <= sequence; ++i) {
            this.commandSequence = i;
            List<Runnable> queries = this.sequenceQueries.remove(this.commandSequence);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
        }
        return this;
    }

    long getLastApplied() {
        return this.lastApplied;
    }

    ServerSessionContext setLastApplied(long index) {
        for (long i = this.lastApplied + 1L; i <= index; ++i) {
            this.lastApplied = i;
            List<Runnable> queries = this.indexQueries.remove(this.lastApplied);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
        }
        return this;
    }

    ServerSessionContext registerSequenceQuery(long sequence, Runnable query) {
        List queries = this.sequenceQueries.computeIfAbsent(sequence, v -> new LinkedList());
        queries.add(query);
        return this;
    }

    ServerSessionContext registerIndexQuery(long index, Runnable query) {
        List queries = this.indexQueries.computeIfAbsent(index, v -> new LinkedList());
        queries.add(query);
        return this;
    }

    ServerSessionContext registerResult(long sequence, ServerStateMachine.Result result) {
        this.results.put(sequence, result);
        return this;
    }

    ServerSessionContext clearResults(long sequence) {
        if (sequence > this.commandLowWaterMark) {
            long i = this.commandLowWaterMark + 1L;
            while (i <= sequence) {
                this.results.remove(i);
                this.commandLowWaterMark = i++;
            }
        }
        return this;
    }

    ServerStateMachine.Result getResult(long sequence) {
        return this.results.get(sequence);
    }

    ServerSessionContext setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    Connection getConnection() {
        return this.connection;
    }

    long getEventIndex() {
        return this.eventIndex;
    }

    @Override
    public Session publish(String event) {
        return this.publish(event, null);
    }

    @Override
    public Session publish(String event, Object message) {
        Assert.state((boolean)this.open, (String)"cannot publish events during session registration", (Object[])new Object[0]);
        Assert.stateNot((this.state == Session.State.CLOSED ? 1 : 0) != 0, (String)"session is closed", (Object[])new Object[0]);
        Assert.stateNot((this.state == Session.State.EXPIRED ? 1 : 0) != 0, (String)"session is expired", (Object[])new Object[0]);
        Assert.state((this.context.type() == ServerStateMachineContext.Type.COMMAND ? 1 : 0) != 0, (String)"session events can only be published during command execution", (Object[])new Object[0]);
        if (this.completeIndex > this.context.index()) {
            return this;
        }
        if (this.event == null || this.event.eventIndex != this.context.index()) {
            long previousIndex = this.eventIndex;
            this.eventIndex = this.context.index();
            this.event = new EventHolder(this.eventIndex, previousIndex);
        }
        this.event.events.add(new Event(event, message));
        return this;
    }

    void commit(long index) {
        if (this.event != null && this.event.eventIndex == index) {
            this.events.add(this.event);
            this.sendEvent(this.event);
        }
    }

    long getLastCompleted() {
        EventHolder event = this.events.peek();
        if (event != null && event.eventIndex > this.completeIndex) {
            return event.eventIndex - 1L;
        }
        return this.lastApplied;
    }

    private ServerSessionContext clearEvents(long index) {
        if (index > this.completeIndex) {
            EventHolder event = this.events.peek();
            while (event != null && event.eventIndex <= index) {
                this.events.remove();
                this.completeIndex = event.eventIndex;
                event = this.events.peek();
            }
            this.completeIndex = index;
        }
        return this;
    }

    ServerSessionContext resendEvents(long index) {
        this.clearEvents(index);
        for (EventHolder event : this.events) {
            this.sendEvent(event);
        }
        return this;
    }

    private void sendEvent(EventHolder event) {
        if (this.connection != null) {
            this.sendEvent(event, this.connection);
        }
    }

    private void sendEvent(EventHolder event, Connection connection) {
        PublishRequest request = ((PublishRequest.Builder)PublishRequest.builder().withSession(this.id())).withEventIndex(event.eventIndex).withPreviousIndex(Math.max(event.previousIndex, this.completeIndex)).withEvents(event.events).build();
        LOGGER.trace("{} - Sending {}", (Object)this.id, (Object)request);
        connection.send((Object)request);
    }

    void suspect() {
        this.setState(Session.State.UNSTABLE);
    }

    void trust() {
        this.setState(Session.State.OPEN);
    }

    void unregister() {
        this.unregistering = true;
    }

    boolean isUnregistering() {
        return this.unregistering;
    }

    void expire(long index) {
        this.setState(Session.State.EXPIRED);
        this.cleanState(index);
    }

    void close(long index) {
        this.setState(Session.State.CLOSED);
        this.cleanState(index);
    }

    private void cleanState(long index) {
        if (this.keepAliveIndex > 0L) {
            this.log.release(this.keepAliveIndex);
        }
        this.context.sessions().unregisterSession(this.id);
        if (this.references == 0L) {
            this.log.release(this.id);
            if (index > 0L) {
                this.log.release(index);
            }
        } else {
            this.closeIndex = index;
        }
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + (int)(this.id ^ this.id >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof Session && ((Session)object).id() == this.id;
    }

    public String toString() {
        return String.format("%s[id=%d]", this.getClass().getSimpleName(), this.id);
    }

    private static class EventHolder {
        private final long eventIndex;
        private final long previousIndex;
        private final List<Event<?>> events = new LinkedList();

        private EventHolder(long eventIndex, long previousIndex) {
            this.eventIndex = eventIndex;
            this.previousIndex = previousIndex;
        }
    }
}

