/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBroadcasterCache
implements BroadcasterCache {
    private final Logger logger = LoggerFactory.getLogger(AbstractBroadcasterCache.class);
    protected final List<CacheMessage> messages = new LinkedList<CacheMessage>();
    protected final Set<String> messagesIds = new HashSet<String>();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected ScheduledFuture<?> scheduledFuture;
    protected long maxCacheTime = TimeUnit.MINUTES.toMillis(2L);
    protected long invalidateCacheInterval = TimeUnit.MINUTES.toMillis(1L);
    protected ScheduledExecutorService reaper = Executors.newSingleThreadScheduledExecutor();
    protected boolean isShared;
    protected final List<BroadcasterCacheInspector> inspectors = new LinkedList<BroadcasterCacheInspector>();
    protected final List<Object> emptyList = Collections.emptyList();
    protected final List<BroadcasterCacheListener> listeners = new LinkedList<BroadcasterCacheListener>();
    protected AtmosphereConfig config;

    @Override
    public void start() {
        this.scheduledFuture = this.reaper.scheduleAtFixedRate(() -> {
            this.readWriteLock.writeLock().lock();
            try {
                long now = System.nanoTime();
                ArrayList<CacheMessage> expiredMessages = new ArrayList<CacheMessage>();
                for (CacheMessage message : this.messages) {
                    if (TimeUnit.NANOSECONDS.toMillis(now - message.getCreateTime()) <= this.maxCacheTime) continue;
                    expiredMessages.add(message);
                }
                for (CacheMessage expiredMessage : expiredMessages) {
                    this.messages.remove(expiredMessage);
                    this.messagesIds.remove(expiredMessage.getId());
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }, 0L, this.invalidateCacheInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void cleanup() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    @Override
    public void stop() {
        this.cleanup();
        if (!this.isShared) {
            this.reaper.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheMessage put(BroadcastMessage message, Long now, String uuid) {
        if (!this.inspect(message)) {
            return null;
        }
        this.logger.trace("Caching message {} for Broadcaster {}", message.message(), (Object)uuid);
        this.readWriteLock.writeLock().lock();
        CacheMessage cacheMessage = null;
        try {
            boolean hasMessageWithSameId = this.messagesIds.contains(message.id());
            if (!hasMessageWithSameId) {
                cacheMessage = new CacheMessage(message.id(), now, message.message(), uuid);
                this.messages.add(cacheMessage);
                this.messagesIds.add(message.id());
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return cacheMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> get(long cacheHeaderTime) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.readWriteLock.readLock().lock();
        try {
            for (CacheMessage cacheMessage : this.messages) {
                if (cacheMessage.getCreateTime() <= cacheHeaderTime) continue;
                result.add(cacheMessage.getMessage());
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        this.logger.trace("Retrieved messages {}", result);
        return result;
    }

    public AbstractBroadcasterCache setInvalidateCacheInterval(long invalidateCacheInterval) {
        this.invalidateCacheInterval = invalidateCacheInterval;
        return this;
    }

    public AbstractBroadcasterCache setMaxCacheTime(long maxCacheTime) {
        this.maxCacheTime = maxCacheTime;
        return this;
    }

    @Override
    public BroadcasterCache inspector(BroadcasterCacheInspector b) {
        this.inspectors.add(b);
        return this;
    }

    protected boolean inspect(BroadcastMessage m) {
        for (BroadcasterCacheInspector b : this.inspectors) {
            if (b.inspect(m)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void configure(AtmosphereConfig config) {
        Object o = config.properties().get("shared");
        if (o != null) {
            this.isShared = Boolean.parseBoolean(o.toString());
        }
        this.reaper = this.isShared ? ExecutorsFactory.getScheduler(config) : Executors.newSingleThreadScheduledExecutor();
        this.config = config;
    }

    @Override
    public BroadcasterCache clearCache(String broadcasterId, String uuid, CacheMessage cache) {
        if (cache != null) {
            this.messages.remove(cache);
            this.messagesIds.remove(cache.getId());
        }
        return this;
    }

    @Override
    public BroadcasterCache excludeFromCache(String broadcasterId, AtmosphereResource r) {
        this.logger.warn("Not supported");
        return this;
    }

    @Override
    public BroadcasterCache cacheCandidate(String broadcasterId, String uuid) {
        this.logger.warn("Not supported");
        return this;
    }

    @Override
    public BroadcasterCache addBroadcasterCacheListener(BroadcasterCacheListener l) {
        this.logger.warn("Not supported");
        return this;
    }

    @Override
    public BroadcasterCache removeBroadcasterCacheListener(BroadcasterCacheListener l) {
        this.logger.warn("Not supported");
        return this;
    }
}

