/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolUtil.class);

    protected static AtmosphereRequestImpl.Builder constructRequest(WebSocket webSocket, String pathInfo, String requestURI, String methodType, String contentType, boolean destroyable) {
        AtmosphereResource resource = webSocket.resource();
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource)).getRequest(false);
        Map<String, Object> m = ProtocolUtil.attributes(webSocket, request);
        AtmosphereRequestImpl.Builder b = ((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)new AtmosphereRequestImpl.Builder().request(request).method(methodType).contentType(contentType == null ? request.getContentType() : contentType).attributes((Map)m)).pathInfo(pathInfo).contextPath(request.getContextPath()).servletPath(request.getServletPath()).requestURI(requestURI).requestURL(request.requestURL()).destroyable(destroyable).headers((Map)request.headersMap())).session(resource.session());
        return b;
    }

    private static Map<String, Object> attributes(WebSocket webSocket, AtmosphereRequest request) {
        ConcurrentHashMap<String, Object> m = new ConcurrentHashMap<String, Object>();
        m.putAll(webSocket.attributes());
        return m;
    }
}

