/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.NotEmptyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NotEmptyValidatorTest
extends BaseValidatorTest {
    private NotEmptyValidator validator;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.validator = new NotEmptyValidator(ValidationScope.MAPPING, "Collection should not be empty");
    }

    @Override
    @After
    public void tearDown() {
        super.setUp();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        Assert.assertTrue((boolean)this.validator.supports(Map.class));
        Assert.assertTrue((boolean)this.validator.supports(List.class));
        Assert.assertTrue((boolean)this.validator.supports(Set.class));
        Assert.assertTrue((boolean)this.validator.supports(Collection.class));
    }

    @Test
    public void testUnsupported() {
        Assert.assertFalse((boolean)this.validator.supports(HashMap.class));
    }

    @Test
    public void testValidate() {
        ArrayList<String> stuff = new ArrayList<String>();
        stuff.add("one");
        stuff.add("two");
        this.validator.validate(stuff, this.validations, "testValidate-1");
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        this.validator.validate(stuff, this.validations, "testValidate-2", ValidationStatus.WARN);
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        ArrayList stuff = new ArrayList();
        this.validator.validate(stuff, this.validations, "testValidateInvalid");
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(this.validationHelper.getCount()));
        Assert.assertEquals((Object)ValidationScope.MAPPING, (Object)((Validation)this.validationHelper.getValidation().get(0)).getScope());
        Assert.assertEquals((Object)"testValidateInvalid", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }
}

