/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.BaseDefaultAtlasContextTest;
import io.atlasmap.core.DefaultAtlasExpressionProcessor;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import org.junit.Assert;
import org.junit.Test;

public class DefaultAtlasExpressionProcessorTest
extends BaseDefaultAtlasContextTest {
    @Test
    public void testSingle() throws AtlasException {
        Field source = this.populateSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", FieldType.STRING, "foo");
        String expression = String.format("${%s:/testPathfoo}", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField(source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assert.assertFalse((String)this.printAudit((AtlasSession)this.session), (boolean)this.session.hasErrors());
        Assert.assertEquals((Object)"foo", (Object)this.session.head().getSourceField().getValue());
    }

    @Test
    public void testCollection() throws Exception {
        FieldGroup source = this.populateCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("IF(ISEMPTY(${%s:/testPathfoo<0>}), null, ${%s:/testPathfoo<>})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        FieldGroup wrapper = new FieldGroup();
        wrapper.getField().add(source);
        wrapper.getField().add(source.getField().get(0));
        this.session.head().setSourceField((Field)wrapper);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assert.assertFalse((String)this.printAudit((AtlasSession)this.session), (boolean)this.session.hasErrors());
        Assert.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assert.assertEquals((Object)"/testPathfoo<>", (Object)fieldGroup.getPath());
        Assert.assertEquals((long)10L, (long)fieldGroup.getField().size());
        Assert.assertEquals((Object)"foo0", (Object)((Field)fieldGroup.getField().get(0)).getValue());
    }

    @Test
    public void testComplexCollection() throws Exception {
        this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("IF(ISEMPTY(${%s:/testPathfoo<0>/value}), null, ${%s:/testPathfoo<>/value})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        FieldGroup wrapper = new FieldGroup();
        wrapper.getField().add((Field)this.reader.sources.get("/testPathfoo<0>/value"));
        wrapper.getField().add((Field)this.reader.sources.get("/testPathfoo<>/value"));
        this.session.head().setSourceField((Field)wrapper);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assert.assertFalse((String)this.printAudit((AtlasSession)this.session), (boolean)this.session.hasErrors());
        Assert.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assert.assertEquals((Object)"/testPathfoo<>/value", (Object)fieldGroup.getPath());
        Assert.assertEquals((long)10L, (long)fieldGroup.getField().size());
        Field childField = (Field)fieldGroup.getField().get(0);
        Assert.assertEquals((Object)"/testPathfoo<0>/value", (Object)childField.getPath());
        Assert.assertEquals((Object)"foo0", (Object)childField.getValue());
        childField = (Field)fieldGroup.getField().get(1);
        Assert.assertEquals((Object)"/testPathfoo<1>/value", (Object)childField.getPath());
        Assert.assertEquals((Object)"foo1", (Object)childField.getValue());
    }

    @Test
    public void testFilter() throws Exception {
        FieldGroup source = this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("FILTER(${%s:/testPathfoo<>}, ${/value} != 'foo1')", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField((Field)source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assert.assertFalse((String)this.printAudit((AtlasSession)this.session), (boolean)this.session.hasErrors());
        Assert.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assert.assertEquals((Object)"/testPathfoo<>", (Object)fieldGroup.getPath());
        Assert.assertEquals((long)9L, (long)fieldGroup.getField().size());
        FieldGroup childFieldGroup = (FieldGroup)fieldGroup.getField().get(0);
        Assert.assertEquals((Object)"/testPathfoo<0>", (Object)childFieldGroup.getPath());
        Assert.assertEquals((long)1L, (long)childFieldGroup.getField().size());
        Assert.assertEquals((Object)"foo0", (Object)((Field)childFieldGroup.getField().get(0)).getValue());
        childFieldGroup = (FieldGroup)fieldGroup.getField().get(1);
        Assert.assertEquals((Object)"/testPathfoo<1>", (Object)childFieldGroup.getPath());
        Assert.assertEquals((long)1L, (long)childFieldGroup.getField().size());
        Assert.assertEquals((Object)"foo2", (Object)((Field)childFieldGroup.getField().get(0)).getValue());
    }

    @Test
    public void testSelect() throws Exception {
        FieldGroup source = this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("SELECT(${%s:/testPathfoo<>}, ${/value})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField((Field)source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assert.assertFalse((String)this.printAudit((AtlasSession)this.session), (boolean)this.session.hasErrors());
        Assert.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assert.assertEquals((Object)"/testPathfoo<>/value", (Object)fieldGroup.getPath());
        Assert.assertEquals((long)10L, (long)fieldGroup.getField().size());
        Field child = (Field)fieldGroup.getField().get(0);
        Assert.assertEquals((Object)"/testPathfoo<0>/value", (Object)child.getPath());
        Assert.assertEquals((Object)"foo0", (Object)child.getValue());
        child = (Field)fieldGroup.getField().get(1);
        Assert.assertEquals((Object)"/testPathfoo<1>/value", (Object)child.getPath());
        Assert.assertEquals((Object)"foo1", (Object)child.getValue());
    }

    @Test
    public void testFilterSelect() throws Exception {
        FieldGroup source = this.populateComplexCollectionSourceField(null, "ATLAS_DEFAULT_SOURCE_DOC", "foo");
        String expression = String.format("SELECT(FILTER(${%s:/testPathfoo<>}, ${/value} != 'foo1'), ${/value})", "ATLAS_DEFAULT_SOURCE_DOC", "ATLAS_DEFAULT_SOURCE_DOC");
        this.recreateSession();
        this.session.head().setSourceField((Field)source);
        DefaultAtlasExpressionProcessor.processExpression((DefaultAtlasSession)this.session, (String)expression);
        Assert.assertFalse((String)this.printAudit((AtlasSession)this.session), (boolean)this.session.hasErrors());
        Assert.assertEquals(FieldGroup.class, this.session.head().getSourceField().getClass());
        FieldGroup fieldGroup = (FieldGroup)this.session.head().getSourceField();
        Assert.assertEquals((Object)"/testPathfoo<>/value", (Object)fieldGroup.getPath());
        Assert.assertEquals((long)9L, (long)fieldGroup.getField().size());
        Field child = (Field)fieldGroup.getField().get(0);
        Assert.assertEquals((Object)"/testPathfoo<0>/value", (Object)child.getPath());
        Assert.assertEquals((Object)"foo0", (Object)child.getValue());
        child = (Field)fieldGroup.getField().get(1);
        Assert.assertEquals((Object)"/testPathfoo<1>/value", (Object)child.getPath());
        Assert.assertEquals((Object)"foo2", (Object)child.getValue());
    }
}

