/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.StringConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class StringConverterTest {
    private StringConverter converter = new StringConverter();

    @Test
    public void convertToBoolean() {
        String f = "0";
        String t = "1";
        String capitalT = "T";
        String capitalF = "F";
        String smallT = "t";
        String smallF = "f";
        String strTrue = "true";
        String strFalse = "false";
        Boolean b = this.converter.toBoolean(t, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        b = this.converter.toBoolean(f, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
        b = this.converter.toBoolean(capitalT, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        b = this.converter.toBoolean(capitalF, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
        b = this.converter.toBoolean(smallT, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        b = this.converter.toBoolean(smallF, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
        b = this.converter.toBoolean(strTrue, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertTrue((boolean)b);
        b = this.converter.toBoolean(strFalse, null, null);
        Assert.assertNotNull((Object)b);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Boolean b = this.converter.toBoolean(null, null, null);
        Assert.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanFallback() {
        String s = "";
        Boolean b = this.converter.toBoolean(s, null, null);
        Assert.assertFalse((boolean)b);
        b = this.converter.toBoolean("junk", null, null);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        String s = "0";
        Byte value = 0;
        Assert.assertEquals((Object)value, (Object)this.converter.toByte(s));
        s = "+127";
        value = 127;
        Assert.assertEquals((Object)value, (Object)this.converter.toByte(s));
        s = "-128";
        value = -128;
        Assert.assertEquals((Object)value, (Object)this.converter.toByte(s));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assert.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToByteMAX() throws Exception {
        String s = String.valueOf(127);
        Byte l = this.converter.toByte(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)127.0, (double)l.byteValue(), (double)0.0);
    }

    @Test
    public void convertToByteMIN() throws Exception {
        String s = String.valueOf(-128);
        Byte l = this.converter.toByte(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)-128.0, (double)l.byteValue(), (double)0.0);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToByteGreaterThanMAX() throws Exception {
        String s = "128";
        this.converter.toByte(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToByteLessThanMIN() throws Exception {
        String s = "-129";
        this.converter.toByte(s);
    }

    @Test
    public void convertToCharacter() throws Exception {
        String s = "0";
        Character c = this.converter.toCharacter(s);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)48L, (long)c.charValue());
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Character c = this.converter.toCharacter(null);
        Assert.assertNull((Object)c);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToCharacterEmptyString() throws Exception {
        String s = "";
        this.converter.toCharacter(s);
    }

    @Test
    public void convertToCharacterStringSpace() throws Exception {
        String s = " ";
        Character c = this.converter.toCharacter(s);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)32L, (long)c.charValue());
    }

    @Test
    public void convertToDate() {
        Date date = this.converter.toDate(Instant.now().toString(), null, null);
        Assert.assertNotNull((Object)date);
        date = this.converter.toDate("2014-02-20T20:04:05.867Z", null, null);
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void convertToDouble() throws Exception {
        String s = "0.0";
        Double d = this.converter.toDouble(s);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() throws Exception {
        Double d = this.converter.toDouble(null);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToDoubleMAX() throws Exception {
        String s = String.valueOf(Double.MAX_VALUE);
        Double d = this.converter.toDouble(s);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)d, (double)0.0);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToDoubleGreaterThanMAX() throws Exception {
        String s = "1.7976931348623157E400";
        this.converter.toDouble(s);
    }

    @Test
    public void convertToDoubleLessThanMIN() throws Exception {
        String s = "-4.9E-325";
        Double d = this.converter.toDouble(s);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToDoubleUnparseable() throws Exception {
        String s = "1.2efff";
        this.converter.toDouble(s);
    }

    @Test
    public void convertToFloat() throws Exception {
        String s = "0";
        Float f = this.converter.toFloat(s);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
        s = "1";
        f = this.converter.toFloat(s);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)1.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() throws Exception {
        Assert.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToFloatMAX() throws Exception {
        String s = "3.4028235E38";
        Float f = this.converter.toFloat(s);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)3.4028234663852886E38, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatMIN() throws Exception {
        String s = "1.401298464324817E-45";
        Float f = this.converter.toFloat(s);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)1.4E-45f, (double)f.floatValue(), (double)0.0);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToFloatUnparsable() throws Exception {
        String s = "QWERTY";
        this.converter.toFloat(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToFloatGreaterThanMAX() throws Exception {
        String s = "3.4028235E39";
        this.converter.toFloat(s);
    }

    @Test
    public void convertToFloatLessThanMIN() throws Exception {
        String s = "1.4E-49";
        Float f = this.converter.toFloat(s);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToInteger() throws Exception {
        String s = "0";
        Integer i = this.converter.toInteger(s);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
        s = "3.5";
        i = this.converter.toInteger(s);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((double)3.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() throws Exception {
        Integer i = this.converter.toInteger(null);
        Assert.assertNull((Object)i);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToIntegerLessThanMIN() throws Exception {
        String s = "-21474836495554545";
        this.converter.toInteger(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToIntegerGreaterThanMAX() throws Exception {
        String s = "214748364755545422145221";
        this.converter.toInteger(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToIntegerUnparseable() throws Exception {
        String s = "2147483648qwerty";
        this.converter.toInteger(s);
    }

    @Test
    public void convertToLong() throws Exception {
        String s = "1";
        Long l = this.converter.toLong(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)1.0, (double)l.longValue(), (double)0.0);
        s = "3.5";
        l = this.converter.toLong(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)3.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() throws Exception {
        Long l = this.converter.toLong(null);
        Assert.assertNull((Object)l);
    }

    @Test
    public void convertToLongMAX() throws Exception {
        String s = String.valueOf(Long.MAX_VALUE);
        Long l = this.converter.toLong(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongMIN() throws Exception {
        String s = String.valueOf(Long.MIN_VALUE);
        Long l = this.converter.toLong(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)-9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToLongGreaterThanMAX() throws Exception {
        String s = "9223372036854775808";
        this.converter.toLong(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToLongLessThanMIN() throws Exception {
        String s = "-9223372036854775809";
        this.converter.toLong(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToLongUnparsable() throws Exception {
        String s = "QWERTY";
        this.converter.toLong(s);
    }

    @Test
    public void convertToShort() throws Exception {
        String aString = "0";
        Short s = this.converter.toShort(aString);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Short s = this.converter.toShort(null);
        Assert.assertNull((Object)s);
    }

    @Test
    public void convertToShortMAX() throws Exception {
        String s = String.valueOf(Short.MAX_VALUE);
        Short l = this.converter.toShort(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)32767.0, (double)l.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortMIN() throws Exception {
        String s = String.valueOf(Short.MIN_VALUE);
        Short l = this.converter.toShort(s);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)-32768.0, (double)l.shortValue(), (double)0.0);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortGreaterThanMAX() throws Exception {
        String s = "9223372036854775808";
        this.converter.toShort(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortLessThanMIN() throws Exception {
        String s = "-9223372036854775809";
        this.converter.toShort(s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortUnparsable() throws Exception {
        String s = "QWERTY";
        this.converter.toShort(s);
    }

    @Test
    public void convertToString() {
        String zero = "0";
        String converted = this.converter.toString(zero, null, null);
        Assert.assertNotNull((Object)converted);
        Assert.assertNotSame((Object)converted, (Object)zero);
        Assert.assertTrue((boolean)"0".equals(converted));
    }

    @Test
    public void convertToStringNull() {
        String s = this.converter.toString(null, null, null);
        Assert.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<StringConverter> aClass = StringConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.STRING) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }

    @Test
    public void testConvertToNumber() throws AtlasConversionException {
        StringConverter converter = new StringConverter();
        Assert.assertNull((Object)converter.toNumber(null));
        Assert.assertNull((Object)converter.toNumber(" "));
        Assert.assertNotNull((Object)converter.toNumber("1"));
        Assert.assertNotNull((Object)converter.toNumber("1.99"));
    }

    @Test(expected=AtlasConversionException.class)
    public void testConvertToNumberAtlasConversionException() throws AtlasConversionException {
        StringConverter converter = new StringConverter();
        Assert.assertNull((Object)converter.toNumber("abc"));
    }
}

