/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.DateConverter;
import io.atlasmap.converters.DateTimeHelper;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DateConverterTest {
    private DateConverter dateConverter = new DateConverter();

    @Test
    public void convertToZonedDateTime() {
        ZonedDateTime zonedDateTime = DateTimeHelper.toZonedDateTime((Date)new Date(), null);
        Assert.assertNotNull((Object)zonedDateTime);
        Assert.assertThat((Object)zonedDateTime, (Matcher)CoreMatchers.instanceOf(ZonedDateTime.class));
        Assert.assertTrue((boolean)zonedDateTime.getZone().getId().equals(ZoneId.systemDefault().getId()));
    }

    @Test
    public void convertToZonedDateTimeWithZoneId() {
        ZonedDateTime zonedDateTime = DateTimeHelper.toZonedDateTime((Date)new Date(), (String)"America/New_York");
        Assert.assertNotNull((Object)zonedDateTime);
        Assert.assertThat((Object)zonedDateTime, (Matcher)CoreMatchers.instanceOf(ZonedDateTime.class));
        Assert.assertTrue((boolean)zonedDateTime.getZone().getId().equals("America/New_York"));
    }

    @Test
    public void convertToLocalDateTime() {
        LocalDateTime localDateTime = DateTimeHelper.convertDateToLocalDateTime((Date)new Date(), null);
        Assert.assertNotNull((Object)localDateTime);
        Assert.assertThat((Object)localDateTime, (Matcher)CoreMatchers.instanceOf(LocalDateTime.class));
    }

    @Test
    public void convertToLocalDateTimeWithZoneId() {
        LocalDateTime localDateTime = DateTimeHelper.convertDateToLocalDateTime((Date)new Date(), (String)"America/New_York");
        Assert.assertNotNull((Object)localDateTime);
        Assert.assertThat((Object)localDateTime, (Matcher)CoreMatchers.instanceOf(LocalDateTime.class));
        Assert.assertTrue((boolean)localDateTime.atZone(ZoneId.of("America/New_York")).getZone().getId().equals("America/New_York"));
    }

    @Test
    public void convertFromLocalDateTime() {
        Date date = DateTimeHelper.convertLocalDateTimeToDate((LocalDateTime)LocalDateTime.now(), null);
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((long)date.getTime(), (long)date.toInstant().toEpochMilli());
    }

    @Test
    public void convertToLocalTime() {
        LocalTime localTime = DateTimeHelper.convertDateToLocalTime((Date)new Date(), null);
        Assert.assertNotNull((Object)localTime);
        Assert.assertThat((Object)localTime, (Matcher)CoreMatchers.instanceOf(LocalTime.class));
    }

    @Test
    public void convertToLocalTimeWithZoneId() {
        LocalTime localTime = DateTimeHelper.convertDateToLocalTime((Date)new Date(), (String)"America/New_York");
        Assert.assertNotNull((Object)localTime);
        Assert.assertThat((Object)localTime, (Matcher)CoreMatchers.instanceOf(LocalTime.class));
    }

    @Test
    public void convertFromLocalTime() {
        Date date = DateTimeHelper.convertLocalTimeToDate((LocalTime)LocalTime.now(), null);
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void convertToLocalDate() {
        LocalDate localDate = DateTimeHelper.convertDateToLocalDate((Date)new Date(), null);
        Assert.assertNotNull((Object)localDate);
        Assert.assertThat((Object)localDate, (Matcher)CoreMatchers.instanceOf(LocalDate.class));
    }

    @Test
    public void convertToLocalDateWithZoneId() {
        LocalDate localDate = DateTimeHelper.convertDateToLocalDate((Date)new Date(), (String)"America/New_York");
        Assert.assertNotNull((Object)localDate);
        Assert.assertThat((Object)localDate, (Matcher)CoreMatchers.instanceOf(LocalDate.class));
    }

    @Test
    public void convertToTimestamp() {
        Timestamp timestamp = this.dateConverter.toSqlTimestamp(new Date());
        Assert.assertNotNull((Object)timestamp);
        Assert.assertThat((Object)timestamp, (Matcher)CoreMatchers.instanceOf(Timestamp.class));
    }

    @Test
    public void convertToTime() {
        Time time = DateTimeHelper.convertDateToTime((Date)new Date(), null);
        Assert.assertNotNull((Object)time);
        Assert.assertThat((Object)time, (Matcher)CoreMatchers.instanceOf(Time.class));
    }

    @Test
    public void convertToTimeWithZoneId() {
        Time time = DateTimeHelper.convertDateToTime((Date)new Date(), (String)"America/New_York");
        Assert.assertNotNull((Object)time);
        Assert.assertThat((Object)time, (Matcher)CoreMatchers.instanceOf(Time.class));
    }

    @Test
    public void convertFromTime() {
        Date date = DateTimeHelper.convertSqlTimeToDate((Time)Time.valueOf(LocalTime.now()), null);
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void convertFromTimeWithZoneId() {
        Date date = DateTimeHelper.convertSqlTimeToDate((Time)Time.valueOf(LocalTime.now()), (String)"America/New_York");
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void convertToSqlDate() {
        java.sql.Date date = DateTimeHelper.convertDateToSqlDate((Date)new Date(), null);
        Assert.assertNotNull((Object)date);
        Assert.assertThat((Object)date, (Matcher)CoreMatchers.instanceOf(java.sql.Date.class));
    }

    @Test
    public void convertFromSqlDate() {
        Date date = DateTimeHelper.convertSqlDateToDate((java.sql.Date)java.sql.Date.valueOf(LocalDate.now()), null);
        Assert.assertNotNull((Object)date);
        Assert.assertThat((Object)date, (Matcher)CoreMatchers.instanceOf(Date.class));
    }

    @Test
    public void convertFromSqlDateWithZoneId() {
        Date date = DateTimeHelper.convertSqlDateToDate((java.sql.Date)java.sql.Date.valueOf(LocalDate.now()), (String)"America/New_York");
        Assert.assertNotNull((Object)date);
        Assert.assertThat((Object)date, (Matcher)CoreMatchers.instanceOf(Date.class));
    }

    @Test
    public void convertToGregorianCalendar() {
        GregorianCalendar gregorianCalendar = DateTimeHelper.convertDateToGregorianCalendar((Date)new Date(), null);
        Assert.assertNotNull((Object)gregorianCalendar);
        Assert.assertThat((Object)gregorianCalendar, (Matcher)CoreMatchers.instanceOf(GregorianCalendar.class));
    }

    @Test
    public void convertToGregorianCalendarWithZoneId() {
        GregorianCalendar gregorianCalendar = DateTimeHelper.convertDateToGregorianCalendar((Date)new Date(), (String)"America/New_York");
        Assert.assertNotNull((Object)gregorianCalendar);
        Assert.assertThat((Object)gregorianCalendar, (Matcher)CoreMatchers.instanceOf(GregorianCalendar.class));
        Assert.assertTrue((boolean)gregorianCalendar.getTimeZone().getID().equals("America/New_York"));
    }

    @Test
    public void convertToCalendar() {
        Calendar calendar = this.dateConverter.toCalendar(new Date());
        Assert.assertNotNull((Object)calendar);
        Assert.assertThat((Object)calendar, (Matcher)CoreMatchers.instanceOf(GregorianCalendar.class));
    }

    @Test
    public void convertToString() {
        String dateString = this.dateConverter.toString(new Date());
        Assert.assertNotNull((Object)dateString);
        Assert.assertThat((Object)dateString, (Matcher)CoreMatchers.instanceOf(String.class));
    }

    @Test
    public void convertToLong() {
        Date now = new Date();
        Long dateAsLong = this.dateConverter.toLong(now);
        Assert.assertNotNull((Object)dateAsLong);
        Assert.assertThat((Object)dateAsLong, (Matcher)CoreMatchers.instanceOf(Long.class));
        Assert.assertTrue((now.getTime() == dateAsLong.longValue() ? 1 : 0) != 0);
    }
}

