/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.CharacterConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class CharacterConverterTest {
    private CharacterConverter converter = new CharacterConverter();

    @Test
    public void convertToBoolean() {
        Character c = Character.valueOf(Character.forDigit(1, 10));
        Boolean t = this.converter.toBoolean(c, null, null);
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)t);
        c = Character.valueOf("T".charAt(0));
        Boolean t2 = this.converter.toBoolean(c, null, null);
        Assert.assertNotNull((Object)t2);
        Assert.assertTrue((boolean)t2);
        c = Character.valueOf("t".charAt(0));
        Boolean t3 = this.converter.toBoolean(c, null, null);
        Assert.assertNotNull((Object)t3);
        Assert.assertTrue((boolean)t3);
        c = Character.valueOf(Character.forDigit(0, 10));
        Boolean f = this.converter.toBoolean(c, null, null);
        Assert.assertNotNull((Object)f);
        Assert.assertFalse((boolean)f);
        c = Character.valueOf("F".charAt(0));
        Boolean f2 = this.converter.toBoolean(c, null, null);
        Assert.assertNotNull((Object)f2);
        Assert.assertFalse((boolean)f2);
        c = Character.valueOf("f".charAt(0));
        Boolean f3 = this.converter.toBoolean(c, null, null);
        Assert.assertNotNull((Object)f3);
        Assert.assertFalse((boolean)f3);
    }

    @Test
    public void convertToBooleanInvalid() {
        Character c = null;
        this.converter.toBoolean(c, null, null);
        Assert.assertNull(c);
    }

    @Test
    public void convertToByte() throws Exception {
        int value = 99;
        Assert.assertEquals((long)value, (long)this.converter.toByte(Character.valueOf('c')).byteValue());
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToByteOutOfRange() throws Exception {
        int value = 99;
        Assert.assertEquals((long)value, (long)this.converter.toByte(Character.valueOf('\ud840')).byteValue());
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assert.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() {
        Character c = Character.valueOf('\u0000');
        Character c2 = this.converter.toCharacter(c);
        Assert.assertNotNull((Object)c2);
        Assert.assertNotSame((Object)c, (Object)c2);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @Test
    public void convertToCharacterNull() {
        Character c = null;
        Character c2 = this.converter.toCharacter(c);
        Assert.assertNull((Object)c2);
    }

    @Test
    public void convertToDouble() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Double d = this.converter.toDouble(c);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)48.0, (double)d, (double)0.0);
        c = Character.valueOf('\uffff');
        d = this.converter.toDouble(c);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((double)65535.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Character c = null;
        Double d = this.converter.toDouble(c);
        Assert.assertNull((Object)d);
    }

    @Test
    public void convertToFloat() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Float f = this.converter.toFloat(c);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)48.0, (double)f.floatValue(), (double)0.0);
        c = Character.valueOf('\uffff');
        f = this.converter.toFloat(c);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals((double)65535.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Character c = null;
        Float f = this.converter.toFloat(c);
        Assert.assertNull((Object)f);
    }

    @Test
    public void convertToInteger() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Integer i = this.converter.toInteger(c);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((double)48.0, (double)i.intValue(), (double)0.0);
        c = Character.valueOf('\uffff');
        i = this.converter.toInteger(c);
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((double)65535.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() {
        Character c = null;
        Integer i = this.converter.toInteger(c);
        Assert.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Long l = this.converter.toLong(c);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)48.0, (double)l.longValue(), (double)0.0);
        c = Character.valueOf('\uffff');
        l = this.converter.toLong(c);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((double)65535.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() {
        Long l = this.converter.toLong(null);
        Assert.assertNull((Object)l);
    }

    @Test
    public void convertToShort() throws Exception {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Short s = this.converter.toShort(c);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((double)48.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Character c = null;
        Short s = this.converter.toShort(c);
        Assert.assertNull((Object)s);
    }

    @Test(expected=AtlasConversionException.class)
    public void convertToShortException() throws Exception {
        Character c = Character.valueOf('\uffff');
        this.converter.toShort(c);
    }

    @Test
    public void convertToString() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        String s = this.converter.toString(c, null, null);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)"0", (Object)s);
    }

    @Test
    public void convertToStringNull() {
        Character c = null;
        String s = this.converter.toString(c, null, null);
        Assert.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<CharacterConverter> aClass = CharacterConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.CHAR) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

