/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.module;

import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.java.module.JavaMappingFieldPairValidator;
import io.atlasmap.java.module.JavaModule;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.NonNullValidator;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaValidationService
extends BaseModuleValidationService<JavaField> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaValidationService.class);
    private static Map<String, AtlasValidator> validatorMap = new HashMap<String, AtlasValidator>();
    private AtlasModuleDetail moduleDetail = JavaModule.class.getAnnotation(AtlasModuleDetail.class);

    public JavaValidationService() {
        this.init();
    }

    public JavaValidationService(AtlasConversionService conversionService, AtlasFieldActionService fieldActionService) {
        super(conversionService, fieldActionService);
        this.init();
    }

    public void init() {
        this.setMappingFieldPairValidator(new JavaMappingFieldPairValidator(this, this.getConversionService()));
        NonNullValidator javaFilePathNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Field path must not be null nor empty");
        NonNullValidator inputFieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "FieldType should not be null nor empty");
        NonNullValidator outputFieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "FieldType should not be null nor empty");
        NonNullValidator fieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Filed type should not be null nor empty");
        validatorMap.put("java.field.type.not.null", (AtlasValidator)fieldTypeNonNullValidator);
        validatorMap.put("java.field.path.not.null", (AtlasValidator)javaFilePathNonNullValidator);
        validatorMap.put("input.field.type.not.null", (AtlasValidator)inputFieldTypeNonNullValidator);
        validatorMap.put("output.field.type.not.null", (AtlasValidator)outputFieldTypeNonNullValidator);
    }

    public void destroy() {
        validatorMap.clear();
    }

    protected AtlasModuleDetail getModuleDetail() {
        return this.moduleDetail;
    }

    protected Class<JavaField> getFieldType() {
        return JavaField.class;
    }

    protected String getModuleFieldName(JavaField field) {
        return field.getName() != null ? field.getName() : field.getPath();
    }

    protected void validateSourceAndTargetTypes(String mappingId, Field inputField, Field outField, List<Validation> validations) {
    }

    protected void validateModuleField(String mappingId, JavaField field, FieldDirection direction, List<Validation> validations) {
        validatorMap.get("java.field.type.not.null").validate((Object)field, validations, mappingId, ValidationStatus.WARN);
        if (direction == FieldDirection.SOURCE) {
            validatorMap.get("input.field.type.not.null").validate((Object)field.getFieldType(), validations, mappingId, ValidationStatus.WARN);
        } else {
            validatorMap.get("output.field.type.not.null").validate((Object)field.getFieldType(), validations, mappingId, ValidationStatus.WARN);
        }
        if (field.getPath() == null) {
            validatorMap.get("java.field.path.not.null").validate((Object)field.getPath(), validations, mappingId);
        }
        this.validateClass(mappingId, field, validations);
    }

    private void validateClass(String mappingId, JavaField field, List<Validation> validations) {
        String clazzName = field.getClassName();
        if (clazzName != null && !clazzName.isEmpty()) {
            Integer major = this.detectClassVersion(clazzName);
            if (major != null) {
                if (major > new Double(System.getProperty("java.class.version")).intValue()) {
                    Validation validation = new Validation();
                    validation.setScope(ValidationScope.MAPPING);
                    validation.setId(mappingId);
                    validation.setMessage(String.format("Class '%s' for field is compiled against unsupported JDK version: %d current JDK: %s", clazzName, major, System.getProperty("java.class.version")));
                    validation.setStatus(ValidationStatus.ERROR);
                    validations.add(validation);
                }
            } else {
                Validation validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage(String.format("Class '%s' for field is not found on the classpath", clazzName));
                validation.setStatus(ValidationStatus.ERROR);
                validations.add(validation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer detectClassVersion(String className) {
        InputStream in;
        Integer major;
        block15: {
            major = null;
            in = null;
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");
            if (in != null || (in = ClassLoader.getSystemResourceAsStream(className.replace('.', '/') + ".class")) != null) break block15;
            Integer n = null;
            if (in == null) return n;
            try {
                in.close();
                return n;
            }
            catch (IOException ie) {
                LOG.error(String.format("Error closing input stream msg: %s", ie.getMessage()), (Throwable)ie);
            }
            return n;
        }
        DataInputStream data = new DataInputStream(in);
        int magic = data.readInt();
        if (magic != -889275714) {
            LOG.error(String.format("Invalid Java class: %s magic value: %s", className, magic));
        }
        int minor = 0xFFFF & data.readShort();
        major = new Integer(0xFFFF & data.readShort());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Detected class: %s version major: %s minor: %s", className, magic, minor));
        }
        if (in == null) return major;
        try {
            in.close();
            return major;
        }
        catch (IOException ie) {
            LOG.error(String.format("Error closing input stream msg: %s", ie.getMessage()), (Throwable)ie);
        }
        return major;
        catch (IOException e) {
            try {
                LOG.error(String.format("Error detected version for class: %s msg: %s", className, e.getMessage()), (Throwable)e);
                if (in == null) return major;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ie) {
                    LOG.error(String.format("Error closing input stream msg: %s", ie.getMessage()), (Throwable)ie);
                }
                throw throwable;
            }
            try {
                in.close();
                return major;
            }
            catch (IOException ie) {
                LOG.error(String.format("Error closing input stream msg: %s", ie.getMessage()), (Throwable)ie);
            }
            return major;
        }
    }
}

