/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.udf;

import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.daffodil.dpath.NodeInfo;
import org.apache.daffodil.dpath.NodeInfo$;
import org.apache.daffodil.dpath.PrimTypeNode;
import org.apache.daffodil.udf.UserDefinedFunction;
import org.apache.daffodil.udf.UserDefinedFunctionFatalErrorException;
import org.apache.daffodil.udf.UserDefinedFunctionIdentification;
import org.apache.daffodil.udf.UserDefinedFunctionProvider;
import org.apache.daffodil.udf.UserDefinedFunctionService;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import org.apache.daffodil.util.Misc$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class UserDefinedFunctionService$
implements Logging {
    public static UserDefinedFunctionService$ MODULE$;
    private String evaluateMethodName;
    private Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification;
    private Class<UserDefinedFunction> classUserDefinedFunction;
    private String currentClassPath;
    private String allFunctionClasses;
    private final HashMap<String, UserDefinedFunctionService.UserDefinedFunctionInfo> udfInfoLookup;
    private final HashMap<String, Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo>> initializedUserDefinedFunctionsCache;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private volatile byte bitmap$0;

    static {
        new UserDefinedFunctionService$();
    }

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    private String logID$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.logID;
    }

    public String logID() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    private String evaluateMethodName$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.evaluateMethodName = "evaluate";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.evaluateMethodName;
    }

    public String evaluateMethodName() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.evaluateMethodName$lzycompute() : this.evaluateMethodName;
    }

    private HashMap<String, UserDefinedFunctionService.UserDefinedFunctionInfo> udfInfoLookup() {
        return this.udfInfoLookup;
    }

    private HashMap<String, Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo>> initializedUserDefinedFunctionsCache() {
        return this.initializedUserDefinedFunctionsCache;
    }

    private Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.classUserDefinedFunctionIdentification = UserDefinedFunctionIdentification.class;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.classUserDefinedFunctionIdentification;
    }

    public Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.classUserDefinedFunctionIdentification$lzycompute() : this.classUserDefinedFunctionIdentification;
    }

    private Class<UserDefinedFunction> classUserDefinedFunction$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.classUserDefinedFunction = UserDefinedFunction.class;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.classUserDefinedFunction;
    }

    public Class<UserDefinedFunction> classUserDefinedFunction() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.classUserDefinedFunction$lzycompute() : this.classUserDefinedFunction;
    }

    private String currentClassPath$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.currentClassPath = ((TraversableOnce)Misc$.MODULE$.classPath().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), scala.collection.Seq$.MODULE$.canBuildFrom())).mkString("\n");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.currentClassPath;
    }

    public String currentClassPath() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.currentClassPath$lzycompute() : this.currentClassPath;
    }

    private String allFunctionClasses$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.allFunctionClasses = ((TraversableOnce)this.udfInfoLookup().values().map((Function1 & Serializable & scala.Serializable)udfi -> {
                    UserDefinedFunctionIdentification a = udfi.udfClass().getAnnotation(MODULE$.classUserDefinedFunctionIdentification());
                    return new StringBuilder(4).append(udfi.udfClass().getName()).append(" => ").append(new StringBuilder(1).append(a.namespaceURI()).append(":").append(a.name()).toString()).toString();
                }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.allFunctionClasses;
    }

    public String allFunctionClasses() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.allFunctionClasses$lzycompute() : this.allFunctionClasses;
    }

    public Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo> lookupUserDefinedFunctionCallingInfo(String namespaceURI, String fname) {
        String udfid = new StringBuilder(1).append(namespaceURI).append(":").append(fname).toString();
        Option udfFunctionCallingInfo = (Option)this.initializedUserDefinedFunctionsCache().getOrElse((Object)udfid, (Function0 & Serializable & scala.Serializable)() -> {
            Option maybeUdfInfo = MODULE$.udfInfoLookup().get((Object)udfid);
            return maybeUdfInfo.flatMap((Function1 & Serializable & scala.Serializable)udfInfo -> {
                Option option;
                try {
                    UserDefinedFunction udf2 = udfInfo.provider().createUserDefinedFunction(namespaceURI, fname);
                    try {
                        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(udf2);
                        option = Option$.MODULE$.apply((Object)udf2);
                    }
                    catch (NotSerializableException e) {
                        BoxedUnit boxedUnit;
                        LogLevel.Error$ fresh$macro$1 = LogLevel.Error$.MODULE$;
                        int fresh$macro$2 = fresh$macro$1.lvl();
                        if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$2) {
                            MODULE$.doLogging((LogLevel.Type)fresh$macro$1, "Error serializing initialized User Defined Function: %s. Could not serialize member of class: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{udf2.getClass().getName(), e.getMessage()}))));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        option = None$.MODULE$;
                    }
                }
                catch (Exception e) {
                    BoxedUnit boxedUnit;
                    Exception exception = e;
                    Throwable throwable = exception instanceof ReflectiveOperationException ? e.getCause() : exception;
                    Throwable actualCause = throwable;
                    LogLevel.Error$ fresh$macro$3 = LogLevel.Error$.MODULE$;
                    int fresh$macro$4 = fresh$macro$3.lvl();
                    if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$4) {
                        MODULE$.doLogging((LogLevel.Type)fresh$macro$3, "Error initializing User Defined Function: %s. Error thrown: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{udfid, actualCause}))));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new UserDefinedFunctionFatalErrorException(new StringBuilder(30).append("User Defined Function '").append(udfid).append("' Error").toString(), actualCause, udfInfo.udfClass().getName(), udfInfo.provider().getClass().getName());
                }
                Option maybeUdf = option;
                return maybeUdf.flatMap((Function1 & Serializable & scala.Serializable)udf -> {
                    None$ none$;
                    Class<?> actualUdfClass;
                    Class<?> expectedUdfClass = udfInfo.udfClass();
                    Class<?> clazz = actualUdfClass = udf.getClass();
                    Class<?> clazz2 = expectedUdfClass;
                    if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                        BoxedUnit boxedUnit;
                        LogLevel.Error$ fresh$macro$5 = LogLevel.Error$.MODULE$;
                        int fresh$macro$6 = fresh$macro$5.lvl();
                        if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$6) {
                            MODULE$.doLogging((LogLevel.Type)fresh$macro$5, "User Defined Function Class Mismatch: %s. Expected: %s Actual: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{udfid, expectedUdfClass, actualUdfClass}))));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        none$ = None$.MODULE$;
                    } else {
                        UserDefinedFunctionService.EvaluateMethodInfo udfInfoEval = udfInfo.evaluateMethodInfo();
                        udfInfoEval.evaluateMethod().method();
                        Some udfci = new Some((Object)new UserDefinedFunctionService.UserDefinedFunctionCallingInfo((UserDefinedFunction)udf, udfInfo.evaluateMethodInfo()));
                        MODULE$.initializedUserDefinedFunctionsCache().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)udfid), (Object)udfci));
                        none$ = udfci;
                    }
                    return none$;
                });
            });
        });
        return udfFunctionCallingInfo;
    }

    private static final /* synthetic */ String providerClassName$lzycompute$1(LazyRef providerClassName$lzy$1, UserDefinedFunctionProvider provider$1) {
        String string;
        LazyRef lazyRef = providerClassName$lzy$1;
        synchronized (lazyRef) {
            string = providerClassName$lzy$1.initialized() ? (String)providerClassName$lzy$1.value() : (String)providerClassName$lzy$1.initialize((Object)provider$1.getClass().getName());
        }
        return string;
    }

    private static final String providerClassName$1(LazyRef providerClassName$lzy$1, UserDefinedFunctionProvider provider$1) {
        return providerClassName$lzy$1.initialized() ? (String)providerClassName$lzy$1.value() : UserDefinedFunctionService$.providerClassName$lzycompute$1(providerClassName$lzy$1, provider$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$2(Class udfc) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        boolean nonUdf;
        boolean nonAnn = !udfc.isAnnotationPresent(MODULE$.classUserDefinedFunctionIdentification());
        boolean bl = nonUdf = !MODULE$.classUserDefinedFunction().isAssignableFrom(udfc);
        if (nonAnn) {
            LogLevel.Warning$ fresh$macro$1 = LogLevel.Warning$.MODULE$;
            int fresh$macro$2 = fresh$macro$1.lvl();
            if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$2) {
                MODULE$.doLogging((LogLevel.Type)fresh$macro$1, "User Defined Function ignored: %s. Missing %s annotation", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{udfc.getName(), MODULE$.classUserDefinedFunctionIdentification().getName()}))));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (nonUdf) {
            LogLevel.Warning$ fresh$macro$3 = LogLevel.Warning$.MODULE$;
            int fresh$macro$4 = fresh$macro$3.lvl();
            if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$4) {
                MODULE$.doLogging((LogLevel.Type)fresh$macro$3, "User Defined Function ignored: %s. Doesn't implement %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{udfc.getName(), MODULE$.classUserDefinedFunction().getName()}))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean ret = !nonAnn && !nonUdf;
        return ret;
    }

    private static final /* synthetic */ Class[] goodFunctionClasses$lzycompute$1(LazyRef goodFunctionClasses$lzy$1, Class[] providerFunctionClasses$1) {
        Class[] classArray;
        LazyRef lazyRef = goodFunctionClasses$lzy$1;
        synchronized (lazyRef) {
            classArray = goodFunctionClasses$lzy$1.initialized() ? (Class[])goodFunctionClasses$lzy$1.value() : (Class[])goodFunctionClasses$lzy$1.initialize(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])providerFunctionClasses$1)).filter((Function1 & Serializable & scala.Serializable)udfc -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionService$.$anonfun$new$2(udfc))));
        }
        return classArray;
    }

    private static final Class[] goodFunctionClasses$1(LazyRef goodFunctionClasses$lzy$1, Class[] providerFunctionClasses$1) {
        return goodFunctionClasses$lzy$1.initialized() ? (Class[])goodFunctionClasses$lzy$1.value() : UserDefinedFunctionService$.goodFunctionClasses$lzycompute$1(goodFunctionClasses$lzy$1, providerFunctionClasses$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$4(Method x$2) {
        String string = x$2.getName();
        String string2 = MODULE$.evaluateMethodName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$1(UserDefinedFunctionProvider provider) {
        Option possibleProviderFunctionClasses;
        Option option;
        LazyRef providerClassName$lzy = new LazyRef();
        try {
            option = Option$.MODULE$.apply((Object)provider.getUserDefinedFunctionClasses());
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            LogLevel.Warning$ fresh$macro$1 = LogLevel.Warning$.MODULE$;
            int fresh$macro$2 = fresh$macro$1.lvl();
            if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$2) {
                MODULE$.doLogging((LogLevel.Type)fresh$macro$1, "User Defined Function Provider ignored: %s. Error loading User Defined Functions: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{UserDefinedFunctionService$.providerClassName$1(providerClassName$lzy, provider), e}))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            option = possibleProviderFunctionClasses = None$.MODULE$;
        }
        if (possibleProviderFunctionClasses.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])possibleProviderFunctionClasses.get())).isEmpty()) {
            BoxedUnit boxedUnit;
            LogLevel.Warning$ fresh$macro$3 = LogLevel.Warning$.MODULE$;
            int fresh$macro$4 = fresh$macro$3.lvl();
            if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$4) {
                MODULE$.doLogging((LogLevel.Type)fresh$macro$3, "User Defined Function Provider ignored: %s. No User Defined Functions found.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{UserDefinedFunctionService$.providerClassName$1(providerClassName$lzy, provider)}))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Class[] providerFunctionClasses;
            LazyRef goodFunctionClasses$lzy = new LazyRef();
            Option option2 = possibleProviderFunctionClasses;
            if (!(option2 instanceof Some)) {
                throw new MatchError((Object)option2);
            }
            Some some = (Some)option2;
            Class[] classArray = providerFunctionClasses = (Class[])some.value();
            Class[] providerFunctionClasses2 = classArray;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])UserDefinedFunctionService$.goodFunctionClasses$1(goodFunctionClasses$lzy, providerFunctionClasses2))).foreach((Function1 & Serializable & scala.Serializable)fc -> {
                BoxedUnit boxedUnit;
                String fcClassName = fc.getName();
                UserDefinedFunctionIdentification fInfo = fc.getDeclaredAnnotation(MODULE$.classUserDefinedFunctionIdentification());
                String fns = fInfo.namespaceURI();
                String fname = fInfo.name();
                Method[] evalMethods = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fc.getMethods())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionService$.$anonfun$new$4(x$2)));
                if (Misc$.MODULE$.isNullOrBlank(fns)) {
                    LogLevel.Warning$ fresh$macro$5 = LogLevel.Warning$.MODULE$;
                    int fresh$macro$6 = fresh$macro$5.lvl();
                    if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$6) {
                        MODULE$.doLogging((LogLevel.Type)fresh$macro$5, "User Defined Function ignored: %s. Annotation namespace field is empty or invalid.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fcClassName}))));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (Misc$.MODULE$.isNullOrBlank(fname)) {
                    LogLevel.Warning$ fresh$macro$7 = LogLevel.Warning$.MODULE$;
                    int fresh$macro$8 = fresh$macro$7.lvl();
                    if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$8) {
                        MODULE$.doLogging((LogLevel.Type)fresh$macro$7, "User Defined Function ignored: %s. Annotation name field is empty or invalid.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fcClassName}))));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])evalMethods)).isEmpty()) {
                    LogLevel.Warning$ fresh$macro$9 = LogLevel.Warning$.MODULE$;
                    int fresh$macro$10 = fresh$macro$9.lvl();
                    if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$10) {
                        MODULE$.doLogging((LogLevel.Type)fresh$macro$9, "User Defined Function ignored: %s. Missing evaluate method: %s:%s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fcClassName, fns, fname}))));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (evalMethods.length > 1) {
                    LogLevel.Warning$ fresh$macro$11 = LogLevel.Warning$.MODULE$;
                    int fresh$macro$12 = fresh$macro$11.lvl();
                    if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$12) {
                        MODULE$.doLogging((LogLevel.Type)fresh$macro$11, "User Defined Function ignored: %s. Overloaded evaluate method: %s:%s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fcClassName, fns, fname}))));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    Method evaluateMethod = (Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])evalMethods)).head();
                    Class[] paramTypes = evaluateMethod.getParameterTypes();
                    Class<?> returnType = evaluateMethod.getReturnType();
                    Tuple2[] initParamTypeConv = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramTypes)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Class c = (Class)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(NodeInfo$.MODULE$.fromClass(c)), (Object)BoxesRunTime.boxToInteger((int)i));
                        return tuple22;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    Option<PrimTypeNode> initRetTypeConv = NodeInfo$.MODULE$.fromClass(returnType);
                    String[] badParams = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initParamTypeConv)).collect((PartialFunction)new scala.Serializable(paramTypes){
                        public static final long serialVersionUID = 0L;
                        private final Class[] paramTypes$1;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Option<PrimTypeNode>, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                Option t = (Option)A1._1();
                                int i = A1._2$mcI$sp();
                                if (t.isEmpty()) {
                                    Class cn = this.paramTypes$1[i];
                                    object = cn.getSimpleName();
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<Option<PrimTypeNode>, Object> x1) {
                            Option t;
                            Tuple2<Option<PrimTypeNode>, Object> tuple2 = x1;
                            boolean bl = tuple2 != null && (t = (Option)tuple2._1()).isEmpty();
                            return bl;
                        }
                        {
                            this.paramTypes$1 = paramTypes$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])badParams)).nonEmpty()) {
                        LogLevel.Warning$ fresh$macro$13 = LogLevel.Warning$.MODULE$;
                        int fresh$macro$14 = fresh$macro$13.lvl();
                        if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$14) {
                            MODULE$.doLogging((LogLevel.Type)fresh$macro$13, "User Defined Function ignored: %s. Unsupported parameter type(s): %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fcClassName, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])badParams)).mkString(",")}))));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else if (initRetTypeConv.isEmpty()) {
                        LogLevel.Warning$ fresh$macro$15 = LogLevel.Warning$.MODULE$;
                        int fresh$macro$16 = fresh$macro$15.lvl();
                        if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$16) {
                            MODULE$.doLogging((LogLevel.Type)fresh$macro$15, "User Defined Function ignored: %s. Unsupported return type: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fcClassName, returnType.getSimpleName()}))));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        PrimTypeNode primTypeNode;
                        Some some;
                        PrimTypeNode evaluateReturnType;
                        List evaluateParamTypes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initParamTypeConv)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable((Option)x$3._1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PrimTypeNode.class))))).toList();
                        Option<PrimTypeNode> option = initRetTypeConv;
                        if (!(option instanceof Some) || (evaluateReturnType = (PrimTypeNode)(some = (Some)option).value()) == null) {
                            throw new MatchError(option);
                        }
                        PrimTypeNode primTypeNode2 = primTypeNode = evaluateReturnType;
                        PrimTypeNode evaluateReturnType2 = primTypeNode2;
                        String key = new StringBuilder(1).append(fns).append(":").append(fname).toString();
                        if (MODULE$.udfInfoLookup().contains((Object)key)) {
                            UserDefinedFunctionService.UserDefinedFunctionInfo udfInfo = (UserDefinedFunctionService.UserDefinedFunctionInfo)MODULE$.udfInfoLookup().apply((Object)key);
                            LogLevel.Warning$ fresh$macro$17 = LogLevel.Warning$.MODULE$;
                            int fresh$macro$18 = fresh$macro$17.lvl();
                            if (MODULE$.getLoggingLevel().lvl() >= fresh$macro$18) {
                                MODULE$.doLogging((LogLevel.Type)fresh$macro$17, "User Defined Function ignored: %s. Duplicate %s from %s found.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fcClassName, key, udfInfo.udfClass().getName()}))));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            UserDefinedFunctionService.UserDefinedFunctionMethod serializableEvaluate = new UserDefinedFunctionService.UserDefinedFunctionMethod(evaluateMethod.getDeclaringClass(), MODULE$.evaluateMethodName(), paramTypes);
                            UserDefinedFunctionService.EvaluateMethodInfo emi = new UserDefinedFunctionService.EvaluateMethodInfo(serializableEvaluate, (List<NodeInfo.Kind>)evaluateParamTypes, evaluateReturnType2);
                            boxedUnit = MODULE$.udfInfoLookup().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new UserDefinedFunctionService.UserDefinedFunctionInfo((Class<?>)fc, provider, emi)));
                        }
                    }
                }
                return boxedUnit;
            });
        }
    }

    private UserDefinedFunctionService$() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.udfInfoLookup = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.initializedUserDefinedFunctionsCache = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            ServiceLoader<UserDefinedFunctionProvider> loader = ServiceLoader.load(UserDefinedFunctionProvider.class);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(loader).asScala()).foreach((Function1 & Serializable & scala.Serializable)provider -> {
                UserDefinedFunctionService$.$anonfun$new$1(provider);
                return BoxedUnit.UNIT;
            });
            boxedUnit2 = BoxedUnit.UNIT;
        }
        catch (ServiceConfigurationError e) {
            BoxedUnit boxedUnit3;
            LogLevel.Error$ fresh$macro$19 = LogLevel.Error$.MODULE$;
            int fresh$macro$20 = fresh$macro$19.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$20) {
                this.doLogging((LogLevel.Type)fresh$macro$19, "Error while loading User Defined Function Providers: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{e.getMessage()}))));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            LogLevel.Debug$ fresh$macro$21 = LogLevel.Debug$.MODULE$;
            int fresh$macro$22 = fresh$macro$21.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$22) {
                this.doLogging((LogLevel.Type)fresh$macro$21, "Current Classpath: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.currentClassPath()}))));
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.allFunctionClasses())).nonEmpty()) {
            LogLevel.Info$ fresh$macro$23 = LogLevel.Info$.MODULE$;
            int fresh$macro$24 = fresh$macro$23.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$24) {
                this.doLogging((LogLevel.Type)fresh$macro$23, "User Defined Functions loaded: %s", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.allFunctionClasses()}))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            LogLevel.Info$ fresh$macro$25 = LogLevel.Info$.MODULE$;
            int fresh$macro$26 = fresh$macro$25.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$26) {
                this.doLogging((LogLevel.Type)fresh$macro$25, "No User Defined Functions loaded.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }
}

