/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.dfa;

import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.processors.DelimiterIterator;
import org.apache.daffodil.processors.dfa.DFA$;
import org.apache.daffodil.processors.dfa.DFADelimiter;
import org.apache.daffodil.processors.dfa.DelimStateBase;
import org.apache.daffodil.processors.dfa.Registers;
import org.apache.daffodil.processors.dfa.Rule;
import org.apache.daffodil.processors.dfa.StateKind$;
import org.apache.daffodil.processors.dfa.WSPStarState;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.IndexedSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a!B\t\u0013\u0003\u0003i\u0002\u0002C\u0014\u0001\u0005\u0003%\u000b\u0011\u0002\u0015\t\u000bU\u0002A\u0011\u0001\u001c\t\u000ba\u0002a\u0011A\u001d\t\u000bu\u0002a\u0011\u0001 \t\u000b)\u0003a\u0011A&\t\u000bA\u0003A\u0011A)\t\u000bi\u0003AQC.\t\u000by\u0003A\u0011A0\t\u0011\t\u0004\u0001R1A\u0005\u0002eB\u0001b\u0019\u0001\t\u0006\u0004%\t!\u000f\u0005\tI\u0002A)\u0019!C\u0001s!AQ\r\u0001EC\u0002\u0013\u0005\u0011\bC\u0003g\u0001\u0011\u0005q\rC\u0003i\u0001\u0011\u0005s\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003j\u0001\u0011E\u0011PA\u0003Ti\u0006$XM\u0003\u0002\u0014)\u0005\u0019AMZ1\u000b\u0005U1\u0012A\u00039s_\u000e,7o]8sg*\u0011q\u0003G\u0001\tI\u00064gm\u001c3jY*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016\faa\u001d;bi\u0016\u001c\bcA\u0010*W%\u0011!\u0006\t\u0002\ty\tLh.Y7f}A\u0019A&M\u001a\u000e\u00035R!AL\u0018\u0002\u000f5,H/\u00192mK*\u0011\u0001\u0007I\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001a.\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005Q\u0002Q\"\u0001\n\u0002\rqJg.\u001b;?)\t\u0019t\u0007\u0003\u0004(\u0005\u0011\u0005\r\u0001K\u0001\tgR\fG/\u001a(v[V\t!\b\u0005\u0002 w%\u0011A\b\t\u0002\u0004\u0013:$\u0018!C:uCR,g*Y7f+\u0005y\u0004C\u0001!H\u001d\t\tU\t\u0005\u0002CA5\t1I\u0003\u0002E9\u00051AH]8pizJ!A\u0012\u0011\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r\u0002\nQA];mKN,\u0012\u0001\u0014\t\u0004YEj\u0005C\u0001\u001bO\u0013\ty%C\u0001\u0003Sk2,\u0017a\u0001:v]R\u0011!+\u0016\t\u0003?MK!\u0001\u0016\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006-\u001a\u0001\raV\u0001\u0002eB\u0011A\u0007W\u0005\u00033J\u0011\u0011BU3hSN$XM]:\u0002\u0011I,hNU;mKN$2A\u0015/^\u0011\u0015Qu\u00011\u0001M\u0011\u00151v\u00011\u0001X\u0003%1\u0017N\u001c3Ti\u0006$X\r\u0006\u0002;A\")\u0011\r\u0003a\u0001\u007f\u0005!a.Y7f\u0003!)UiQ*uCR,\u0017aB#D'R\fG/Z\u0001\u000b'R\f'\u000f^*uCR,\u0017A\u0003)U\u000bJk5\u000b^1uK\u0006A\u0001O]5oiN#(\u000fF\u0001@\u0003!!xn\u0015;sS:<\u0017\u0001E2pk2$')\u001a$jeN$8\t[1s)\rYgn\u001d\t\u0003?1L!!\u001c\u0011\u0003\u000f\t{w\u000e\\3b]\")qn\u0004a\u0001a\u000611\r[1s\u0013:\u0004\"aH9\n\u0005I\u0004#\u0001B\"iCJDQ\u0001^\bA\u0002U\f\u0011\u0002Z3mS6LE/\u001a:\u0011\u0005Y<X\"\u0001\u000b\n\u0005a$\"!\u0005#fY&l\u0017\u000e^3s\u0013R,'/\u0019;peR\u00191N_>\t\u000b=\u0004\u0002\u0019\u00019\t\u000bq\u0004\u0002\u0019A?\u0002\u0003\u0011\u0004\"\u0001\u000e@\n\u0005}\u0014\"\u0001\u0004#G\u0003\u0012+G.[7ji\u0016\u0014\b")
public abstract class State
implements Serializable {
    private int EECState;
    private int ECState;
    private int StartState;
    private int PTERMState;
    private final Function0<ArrayBuffer<State>> states;
    private volatile byte bitmap$0;

    public abstract int stateNum();

    public abstract String stateName();

    public abstract ArrayBuffer<Rule> rules();

    public void run(Registers r) {
        if (r.state() != this.stateNum()) {
            throw Assert$.MODULE$.abort("Invariant broken: r.state.==(State.this.stateNum)");
        }
        this.runRules(this.rules(), r);
    }

    public final void runRules(ArrayBuffer<Rule> rules, Registers r) {
        while (r.actionNum() < rules.length()) {
            Rule rule = (Rule)rules.apply(r.actionNum());
            boolean useThisRule = rule.test(r);
            if (useThisRule) {
                rule.act(r);
                return;
            }
            r.actionNum_$eq(r.actionNum() + 1);
        }
        r.status_$eq(StateKind$.MODULE$.Failed());
    }

    public int findState(String name) {
        return ((State)((IndexedSeqOptimized)this.states.apply()).find((Function1 & java.io.Serializable & Serializable)st -> BoxesRunTime.boxToBoolean((boolean)State.$anonfun$findState$1(name, st))).get()).stateNum();
    }

    private int EECState$lzycompute() {
        State state = this;
        synchronized (state) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.EECState = this.findState("EECState");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.EECState;
    }

    public int EECState() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.EECState$lzycompute() : this.EECState;
    }

    private int ECState$lzycompute() {
        State state = this;
        synchronized (state) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ECState = this.findState("ECState");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ECState;
    }

    public int ECState() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.ECState$lzycompute() : this.ECState;
    }

    private int StartState$lzycompute() {
        State state = this;
        synchronized (state) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.StartState = this.findState("StartState");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.StartState;
    }

    public int StartState() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.StartState$lzycompute() : this.StartState;
    }

    private int PTERMState$lzycompute() {
        State state = this;
        synchronized (state) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.PTERMState = this.findState("PTERM0");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.PTERMState;
    }

    public int PTERMState() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.PTERMState$lzycompute() : this.PTERMState;
    }

    public String printStr() {
        return ((TraversableOnce)this.states.apply()).mkString();
    }

    public String toString() {
        return new StringBuilder(1).append(this.stateName()).append("_").append(this.stateNum()).toString();
    }

    public boolean couldBeFirstChar(char charIn, DelimiterIterator delimIter) {
        delimIter.reset();
        while (delimIter.hasNext()) {
            if (!this.couldBeFirstChar(charIn, delimIter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean couldBeFirstChar(char charIn, DFADelimiter d) {
        boolean bl;
        State[] states = d.states();
        State pTerm0 = states[0];
        if (pTerm0 instanceof WSPStarState) {
            WSPStarState wspStar = (WSPStarState)pTerm0;
            if (wspStar.checkMatch(charIn)) {
                bl = true;
            } else {
                if (wspStar.nextState() == DFA$.MODULE$.FinalState()) {
                    throw Assert$.MODULE$.impossibleCase();
                }
                DelimStateBase pTerm1 = (DelimStateBase)states[1];
                bl = pTerm1.checkMatch(charIn);
            }
        } else {
            bl = ((DelimStateBase)pTerm0).checkMatch(charIn);
        }
        boolean res = bl;
        return res;
    }

    public static final /* synthetic */ boolean $anonfun$findState$1(String name$1, State st) {
        String string = st.stateName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public State(Function0<ArrayBuffer<State>> states) {
        this.states = states;
    }
}

