/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.Validations;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultAtlasSession
implements AtlasInternalSession {
    private AtlasContext atlasContext;
    private final AtlasMapping mapping;
    private Audits audits;
    private Validations validations;
    private Map<String, Object> sourceProperties;
    private Map<String, Object> targetProperties;
    private AtlasPropertyStrategy propertyStrategy;
    private Map<String, Object> sourceMap;
    private Map<String, Object> targetMap;
    private Map<String, AtlasFieldReader> fieldReaderMap;
    private Map<String, AtlasFieldWriter> fieldWriterMap;
    private AtlasInternalSession.Head head = new HeadImpl(this);

    public DefaultAtlasSession(DefaultAtlasContext context) throws AtlasException {
        this.atlasContext = context;
        this.initialize();
        if (context.getMapping() == null) {
            this.mapping = null;
            return;
        }
        this.mapping = context.getADMArchiveHandler().cloneMappingDefinition();
    }

    protected void initialize() {
        this.sourceProperties = new ConcurrentHashMap<String, Object>();
        this.targetProperties = new ConcurrentHashMap<String, Object>();
        this.validations = new Validations();
        this.audits = new Audits();
        this.sourceMap = new HashMap<String, Object>();
        this.targetMap = new HashMap<String, Object>();
        this.fieldReaderMap = new HashMap<String, AtlasFieldReader>();
        this.fieldWriterMap = new HashMap<String, AtlasFieldWriter>();
        this.head.unset();
    }

    public AtlasContext getAtlasContext() {
        return this.atlasContext;
    }

    public void setAtlasContext(AtlasContext atlasContext) {
        this.atlasContext = atlasContext;
        this.head.unset();
    }

    public AtlasMapping getMapping() {
        return this.mapping;
    }

    public Validations getValidations() {
        return this.validations;
    }

    public void setValidations(Validations validations) {
        this.validations = validations;
    }

    public Audits getAudits() {
        return this.audits;
    }

    public void setAudits(Audits audits) {
        this.audits = audits;
    }

    public Object getDefaultSourceDocument() {
        return this.sourceMap.get("ATLAS_DEFAULT_SOURCE_DOC");
    }

    public Object getSourceDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.getDefaultSourceDocument();
        }
        if (this.sourceMap.containsKey(docId)) {
            return this.sourceMap.get(docId);
        }
        if (this.sourceMap.size() == 1 && this.sourceMap.containsKey("ATLAS_DEFAULT_SOURCE_DOC")) {
            AtlasUtil.addAudit((AtlasSession)this, null, String.format("There's no source document with docId='%s', returning default", docId), null, AuditStatus.WARN, null);
            return this.getDefaultSourceDocument();
        }
        AtlasUtil.addAudit((AtlasSession)this, null, String.format("There's no source document with docId='%s'", docId), null, AuditStatus.WARN, null);
        return null;
    }

    public boolean hasSourceDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.sourceMap.containsKey("ATLAS_DEFAULT_SOURCE_DOC");
        }
        return this.sourceMap.containsKey(docId);
    }

    public Map<String, Object> getSourceDocumentMap() {
        return Collections.unmodifiableMap(this.sourceMap);
    }

    public Object getDefaultTargetDocument() {
        return this.targetMap.get("ATLAS_DEFAULT_TARGET_DOC");
    }

    public Object getTargetDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.getDefaultTargetDocument();
        }
        if (this.targetMap.containsKey(docId)) {
            return this.targetMap.get(docId);
        }
        if (this.targetMap.size() == 1 && this.targetMap.containsKey("ATLAS_DEFAULT_TARGET_DOC")) {
            AtlasUtil.addAudit((AtlasSession)this, null, String.format("There's no target document with docId='%s', returning default", docId), null, AuditStatus.WARN, null);
            return this.getDefaultTargetDocument();
        }
        AtlasUtil.addAudit((AtlasSession)this, null, String.format("There's no target document with docId='%s'", docId), null, AuditStatus.WARN, null);
        return null;
    }

    public boolean hasTargetDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.targetMap.containsKey("ATLAS_DEFAULT_TARGET_DOC");
        }
        return this.targetMap.containsKey(docId);
    }

    public Map<String, Object> getTargetDocumentMap() {
        return Collections.unmodifiableMap(this.targetMap);
    }

    public void setDefaultSourceDocument(Object sourceDoc) {
        this.sourceMap.put("ATLAS_DEFAULT_SOURCE_DOC", sourceDoc);
    }

    public void setSourceDocument(String docId, Object sourceDoc) {
        if (docId == null || docId.isEmpty()) {
            this.setDefaultSourceDocument(sourceDoc);
        } else {
            if (this.sourceMap.isEmpty()) {
                this.setDefaultSourceDocument(sourceDoc);
            }
            this.sourceMap.put(docId, sourceDoc);
        }
    }

    public void setDefaultTargetDocument(Object targetDoc) {
        this.targetMap.put("ATLAS_DEFAULT_TARGET_DOC", targetDoc);
    }

    public void setTargetDocument(String docId, Object targetDoc) {
        if (docId == null || docId.isEmpty()) {
            this.setDefaultTargetDocument(targetDoc);
        } else {
            if (this.targetMap.isEmpty()) {
                this.setDefaultTargetDocument(targetDoc);
            }
            this.targetMap.put(docId, targetDoc);
        }
    }

    public AtlasFieldReader getFieldReader(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldReaderMap.get("ATLAS_DEFAULT_SOURCE_DOC");
        }
        return this.fieldReaderMap.get(docId);
    }

    public <T extends AtlasFieldReader> T getFieldReader(String docId, Class<T> clazz) {
        return (T)((AtlasFieldReader)clazz.cast(this.getFieldReader(docId)));
    }

    public void setFieldReader(String docId, AtlasFieldReader reader) {
        if (docId == null || docId.isEmpty()) {
            this.fieldReaderMap.put("ATLAS_DEFAULT_SOURCE_DOC", reader);
        } else {
            this.fieldReaderMap.put(docId, reader);
        }
    }

    public AtlasFieldReader removeFieldReader(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldReaderMap.remove("ATLAS_DEFAULT_SOURCE_DOC");
        }
        return this.fieldReaderMap.remove(docId);
    }

    public AtlasFieldWriter getFieldWriter(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldWriterMap.get("ATLAS_DEFAULT_TARGET_DOC");
        }
        return this.fieldWriterMap.get(docId);
    }

    public <T extends AtlasFieldWriter> T getFieldWriter(String docId, Class<T> clazz) {
        return (T)((AtlasFieldWriter)clazz.cast(this.getFieldWriter(docId)));
    }

    public void setFieldWriter(String docId, AtlasFieldWriter writer) {
        if (docId == null || docId.isEmpty()) {
            this.fieldWriterMap.put("ATLAS_DEFAULT_TARGET_DOC", writer);
        }
        this.fieldWriterMap.put(docId, writer);
    }

    public AtlasFieldWriter removeFieldWriter(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldWriterMap.remove("ATLAS_DEFAULT_TARGET_DOC");
        }
        return this.fieldWriterMap.remove(docId);
    }

    public AtlasInternalSession.Head head() {
        return this.head;
    }

    @Deprecated
    public Map<String, Object> getProperties() {
        return this.getSourceProperties();
    }

    public Map<String, Object> getSourceProperties() {
        return this.sourceProperties;
    }

    public Map<String, Object> getTargetProperties() {
        return this.targetProperties;
    }

    public AtlasPropertyStrategy getAtlasPropertyStrategy() {
        return this.propertyStrategy;
    }

    public void setAtlasPropertyStrategy(AtlasPropertyStrategy strategy) {
        this.propertyStrategy = strategy;
    }

    public Integer errorCount() {
        int e = 0;
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.ERROR.equals((Object)audit.getStatus())) continue;
            ++e;
        }
        return e;
    }

    public boolean hasErrors() {
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.ERROR.equals((Object)audit.getStatus())) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarns() {
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.WARN.equals((Object)audit.getStatus())) continue;
            return true;
        }
        return false;
    }

    public Integer warnCount() {
        int w = 0;
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.WARN.equals((Object)audit.getStatus())) continue;
            ++w;
        }
        return w;
    }

    private class HeadImpl
    implements AtlasInternalSession.Head {
        private DefaultAtlasSession session;
        private Mapping mapping;
        private LookupTable lookupTable;
        private Field sourceField;
        private Field targetField;
        private List<Audit> audits = new LinkedList<Audit>();

        public HeadImpl(DefaultAtlasSession session) {
            this.session = session;
        }

        public Mapping getMapping() {
            return this.mapping;
        }

        public LookupTable getLookupTable() {
            return this.lookupTable;
        }

        public Field getSourceField() {
            return this.sourceField;
        }

        public Field getTargetField() {
            return this.targetField;
        }

        public AtlasInternalSession.Head setMapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public AtlasInternalSession.Head setLookupTable(LookupTable table) {
            this.lookupTable = table;
            return this;
        }

        public AtlasInternalSession.Head setSourceField(Field sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public AtlasInternalSession.Head setTargetField(Field targetField) {
            this.targetField = targetField;
            return this;
        }

        public AtlasInternalSession.Head unset() {
            this.mapping = null;
            this.lookupTable = null;
            this.sourceField = null;
            this.targetField = null;
            return this;
        }

        public boolean hasError() {
            for (Audit audit : this.audits) {
                if (audit.getStatus() != AuditStatus.ERROR) continue;
                return true;
            }
            return false;
        }

        public AtlasInternalSession.Head addAudit(AuditStatus status, String docId, String path, String message) {
            String docName = AtlasUtil.getDocumentNameById(this.session.getMapping(), docId);
            Audit audit = AtlasUtil.createAudit(status, docId, docName, path, null, message);
            this.audits.add(audit);
            return this;
        }

        public List<Audit> getAudits() {
            return this.audits;
        }
    }
}

