/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasActionProcessor;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.ActionParameter;
import io.atlasmap.v2.ActionParameters;
import io.atlasmap.v2.ActionResolver;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.CustomAction;
import io.atlasmap.v2.Expression;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Multiplicity;
import io.atlasmap.v2.SimpleField;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasFieldActionService
implements AtlasFieldActionService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasFieldActionService.class);
    private static DefaultAtlasFieldActionService instance;
    private static Set<String> listClasses;
    private static Set<String> mapClasses;
    private List<ActionProcessor> actionProcessors = new ArrayList<ActionProcessor>();
    private ReadWriteLock actionProcessorsLock = new ReentrantReadWriteLock();
    private AtlasConversionService conversionService = null;
    private ActionResolver actionResolver = null;

    private DefaultAtlasFieldActionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultAtlasFieldActionService getInstance() {
        if (instance != null) return instance;
        Class<DefaultAtlasFieldActionService> clazz = DefaultAtlasFieldActionService.class;
        synchronized (DefaultAtlasFieldActionService.class) {
            if (instance != null) return instance;
            instance = new DefaultAtlasFieldActionService(DefaultAtlasConversionService.getInstance());
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        this.init(this.getClass().getClassLoader());
    }

    private JavaType javaType(Type type) {
        return TypeFactory.defaultInstance().constructType(type);
    }

    public void init(ClassLoader classLoader) {
        Lock writeLock = this.actionProcessorsLock.writeLock();
        try {
            writeLock.lock();
            this.actionProcessors.clear();
            this.actionResolver = ActionResolver.getInstance().init(classLoader);
            this.actionProcessors.addAll(this.loadFieldActions(classLoader));
        }
        finally {
            writeLock.unlock();
        }
    }

    public List<ActionProcessor> loadFieldActions() {
        return this.loadFieldActions(this.getClass().getClassLoader());
    }

    public List<ActionProcessor> loadFieldActions(ClassLoader classLoader) {
        ServiceLoader<io.atlasmap.spi.AtlasFieldAction> fieldActionServiceLoader = ServiceLoader.load(io.atlasmap.spi.AtlasFieldAction.class, classLoader);
        ServiceLoader<AtlasFieldAction> compat = ServiceLoader.load(AtlasFieldAction.class, classLoader);
        ArrayList<ActionProcessor> answer = new ArrayList<ActionProcessor>();
        fieldActionServiceLoader.forEach(atlasFieldAction -> this.createActionProcessor((io.atlasmap.spi.AtlasFieldAction)atlasFieldAction, (List<ActionProcessor>)answer));
        compat.forEach(atlasFieldAction -> this.createActionProcessor((io.atlasmap.spi.AtlasFieldAction)atlasFieldAction, answer));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Loaded %s Field Actions", answer.size()));
        }
        return answer;
    }

    private void createActionProcessor(io.atlasmap.spi.AtlasFieldAction atlasFieldAction, List<ActionProcessor> answer) {
        Method[] methods;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading FieldAction class: " + atlasFieldAction.getClass().getCanonicalName());
        }
        Class<?> clazz = atlasFieldAction.getClass();
        for (Method method : methods = clazz.getMethods()) {
            ActionProcessor det = this.createDetailFromFieldActionInfo(clazz, method);
            if (det != null) {
                answer.add(det);
            }
            if ((det = this.createDetailFromProcessor(clazz, method)) == null) continue;
            answer.add(det);
        }
    }

    private ActionProcessor createDetailFromFieldActionInfo(final Class<?> clazz, final Method method) {
        Class<?> actionClazz;
        AtlasFieldActionInfo annotation = method.getAnnotation(AtlasFieldActionInfo.class);
        if (annotation == null) {
            return null;
        }
        final ActionDetail det = new ActionDetail();
        det.setClassName(clazz.getName());
        det.setMethod(method.getName());
        det.setName(annotation.name());
        det.setSourceType(annotation.sourceType());
        det.setTargetType(annotation.targetType());
        CollectionType sourceCollection = annotation.sourceCollectionType();
        CollectionType targetCollection = annotation.sourceCollectionType();
        if (sourceCollection != null && sourceCollection != CollectionType.NONE) {
            det.setMultiplicity(Multiplicity.MANY_TO_ONE);
        } else if (targetCollection != null && targetCollection != CollectionType.NONE) {
            det.setMultiplicity(Multiplicity.ONE_TO_MANY);
        } else {
            det.setMultiplicity(Multiplicity.ONE_TO_ONE);
        }
        try {
            actionClazz = Class.forName("io.atlasmap.v2." + annotation.name());
        }
        catch (Exception e) {
            actionClazz = null;
            det.setCustom(Boolean.valueOf(true));
        }
        try {
            det.setActionSchema(actionClazz);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not get json schema for action=%s msg=%s", annotation.name(), e.getMessage()), (Throwable)e);
        }
        try {
            if (det.isCustom() == null || !det.isCustom().booleanValue()) {
                det.setParameters(this.detectFieldActionParameters(actionClazz));
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error(String.format("Error detecting parameters for field action=%s msg=%s", annotation.name(), e.getMessage()), (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loaded FieldAction: " + det.getName());
        }
        final Class<?> finalActionClazz = actionClazz;
        return new ActionProcessor(){

            @Override
            public ActionDetail getActionDetail() {
                return det;
            }

            @Override
            public Class<? extends Action> getActionClass() {
                return finalActionClazz;
            }

            @Override
            public Object process(Action action, Object sourceObject) throws AtlasException {
                if (det == null) {
                    return sourceObject;
                }
                Object targetObject = null;
                try {
                    Object convertedSourceObject = this.convertSourceObject(sourceObject);
                    if (Modifier.isStatic(method.getModifiers())) {
                        targetObject = det.isCustom() != null && det.isCustom().booleanValue() ? (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(null, new Object[0]) : method.invoke(null, convertedSourceObject)) : (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(null, action) : method.invoke(null, action, convertedSourceObject));
                    } else {
                        Object object = clazz.newInstance();
                        targetObject = det.isCustom() != null && det.isCustom().booleanValue() ? (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(object, new Object[0]) : method.invoke(object, convertedSourceObject)) : (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(object, action) : method.invoke(object, action, convertedSourceObject));
                    }
                }
                catch (Throwable e) {
                    throw new AtlasException(String.format("Error processing action %s", det.getName()), e);
                }
                return targetObject;
            }

            private Object convertSourceObject(Object sourceObject) throws AtlasConversionException {
                int paramCount = method.getParameterCount();
                if (paramCount < 2) {
                    return null;
                }
                Class<?> paramType = method.getParameterTypes()[1];
                if (paramType.isInstance(sourceObject)) {
                    return sourceObject;
                }
                return DefaultAtlasFieldActionService.this.conversionService.convertType(sourceObject, null, paramType, null);
            }
        };
    }

    private ActionProcessor createDetailFromProcessor(Class<?> clazz, final Method method) {
        Type[] genericParameterTypes;
        AtlasActionProcessor annotation = method.getAnnotation(AtlasActionProcessor.class);
        if (annotation == null) {
            return null;
        }
        if (method.getParameterCount() < 1) {
            LOG.debug("Invalid @AtlasActionProcessor method.  Expected at least 1 parameter: " + method);
        }
        Class<?> actionClazz = null;
        if (Action.class.isAssignableFrom(method.getParameterTypes()[0])) {
            actionClazz = method.getParameterTypes()[0];
        } else {
            LOG.debug("Invalid @AtlasActionProcessor method.  1st parameter does not subclass " + Action.class.getName() + ": " + method);
        }
        Class<?> targetClass = method.getReturnType();
        String name = this.actionResolver.toId(actionClazz);
        final ActionDetail det = new ActionDetail();
        det.setClassName(clazz.getName());
        det.setMethod(method.getName());
        det.setName(name);
        det.setTargetType(this.toFieldType(targetClass, method.getGenericReturnType()));
        if (!clazz.getPackage().getName().equals("io.atlasmap.actions")) {
            det.setCustom(Boolean.valueOf(true));
        }
        if ((genericParameterTypes = method.getGenericParameterTypes()).length >= 2) {
            Class<?> sourceClass = method.getParameterTypes()[1];
            if (annotation.sourceType() != FieldType.NONE) {
                det.setSourceType(annotation.sourceType());
            } else {
                det.setSourceType(this.toFieldType(sourceClass, method.getGenericParameterTypes()[1]));
            }
            CollectionType sourceCollection = this.toFieldCollectionType(sourceClass);
            CollectionType targetCollection = this.toFieldCollectionType(targetClass);
            if (sourceCollection != CollectionType.NONE) {
                if (targetCollection != CollectionType.NONE) {
                    det.setMultiplicity(Multiplicity.MANY_TO_MANY);
                } else {
                    det.setMultiplicity(Multiplicity.MANY_TO_ONE);
                }
            } else if (targetCollection != CollectionType.NONE) {
                det.setMultiplicity(Multiplicity.ONE_TO_MANY);
            } else {
                det.setMultiplicity(Multiplicity.ONE_TO_ONE);
            }
        } else if (genericParameterTypes.length == 1) {
            det.setMultiplicity(Multiplicity.ZERO_TO_ONE);
        }
        try {
            det.setActionSchema(actionClazz);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not get json schema for action=%s msg=%s", clazz.getName(), e.getMessage()), (Throwable)e);
        }
        try {
            det.setParameters(this.detectFieldActionParameters(actionClazz));
        }
        catch (ClassNotFoundException e) {
            LOG.error(String.format("Error detecting parameters for field action=%s msg=%s", det.getName(), e.getMessage()), (Throwable)e);
        }
        Object o = null;
        try {
            o = Modifier.isStatic(method.getModifiers()) ? clazz.newInstance() : null;
        }
        catch (Throwable e) {
            LOG.error(String.format("Error creating object instance for action=%s msg=%s", det.getName(), e.getMessage()), e);
        }
        final Object object = o;
        final Class<?> finalActionClazz = actionClazz;
        return new ActionProcessor(){

            @Override
            public ActionDetail getActionDetail() {
                return det;
            }

            @Override
            public Class<? extends Action> getActionClass() {
                return finalActionClazz;
            }

            @Override
            public Object process(Action action, Object sourceObject) throws AtlasException {
                try {
                    if (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE) {
                        return method.invoke(object, action);
                    }
                    sourceObject = this.convertSourceObject(sourceObject);
                    return method.invoke(object, action, sourceObject);
                }
                catch (Throwable e) {
                    throw new AtlasException(String.format("Error processing action %s", det.getName()), e);
                }
            }

            private Object convertSourceObject(Object sourceObject) throws AtlasConversionException {
                if (sourceObject == null) {
                    return null;
                }
                Class<?> paramType = method.getParameterTypes()[1];
                CollectionType paramCollectionType = DefaultAtlasFieldActionService.this.toFieldCollectionType(paramType);
                CollectionType sourceCollectionType = DefaultAtlasFieldActionService.this.toFieldCollectionType(sourceObject.getClass());
                if (paramCollectionType != CollectionType.NONE) {
                    Class itemClass;
                    Type itemType = method.getGenericParameterTypes()[1];
                    Class clazz = itemClass = paramType.isArray() ? paramType.getComponentType() : (Class)((ParameterizedType)itemType).getActualTypeArguments()[0];
                    List<Object> sourceList = sourceCollectionType != CollectionType.NONE ? (sourceCollectionType == CollectionType.ARRAY ? Arrays.asList(sourceObject) : (sourceCollectionType == CollectionType.LIST ? (List<Object>)sourceObject : (sourceCollectionType == CollectionType.MAP ? new ArrayList(((Map)sourceObject).values()) : new ArrayList<Object>((Collection)sourceObject)))) : Arrays.asList(sourceObject);
                    DefaultAtlasFieldActionService.this.convertItems(sourceList, itemClass);
                    if (paramType.isArray()) {
                        return sourceList.toArray();
                    }
                    return sourceList;
                }
                if (paramType.isInstance(sourceObject)) {
                    return sourceObject;
                }
                return DefaultAtlasFieldActionService.this.conversionService.convertType(sourceObject, null, paramType, null);
            }
        };
    }

    private void convertItems(List<Object> sourceList, Class<?> itemClass) throws AtlasConversionException {
        for (int i = 0; i < sourceList.size(); ++i) {
            Object item = sourceList.get(i);
            if (item != null) {
                item = this.conversionService.convertType(item, null, itemClass, null);
            }
            sourceList.set(i, item);
        }
    }

    private CollectionType toFieldCollectionType(Class<?> clazz) {
        if (clazz.isArray()) {
            return CollectionType.ARRAY;
        }
        if (clazz == Collection.class) {
            return CollectionType.ALL;
        }
        if (listClasses.contains(clazz.getName())) {
            return CollectionType.LIST;
        }
        if (mapClasses.contains(clazz.getName())) {
            return CollectionType.MAP;
        }
        return CollectionType.NONE;
    }

    private FieldType toFieldType(Class<?> clazz, Type parameterType) {
        switch (this.toFieldCollectionType(clazz)) {
            case ARRAY: {
                return this.toFieldType(clazz.getComponentType(), parameterType);
            }
            case ALL: {
                Type t = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
                return DefaultAtlasConversionService.getInstance().fieldTypeFromClass((Class)t);
            }
            case LIST: {
                Type t = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
                return DefaultAtlasConversionService.getInstance().fieldTypeFromClass((Class)t);
            }
            case MAP: {
                Type t = ((ParameterizedType)parameterType).getActualTypeArguments()[1];
                return DefaultAtlasConversionService.getInstance().fieldTypeFromClass((Class)t);
            }
        }
        return DefaultAtlasConversionService.getInstance().fieldTypeFromClass(clazz);
    }

    private ActionParameters detectFieldActionParameters(Class<?> actionClazz) throws ClassNotFoundException {
        ActionParameters params = null;
        for (Method method : actionClazz.getMethods()) {
            if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
            if (params == null) {
                params = new ActionParameters();
            }
            ActionParameter actionParam = null;
            for (Parameter methodParam : method.getParameters()) {
                actionParam = new ActionParameter();
                actionParam.setName(this.camelize(method.getName().substring("set".length())));
                actionParam.setFieldType(this.getConversionService().fieldTypeFromClass(methodParam.getType()));
                if (methodParam.getType().isEnum()) {
                    actionParam.setFieldType(FieldType.STRING);
                    try {
                        for (Object e : methodParam.getType().getEnumConstants()) {
                            Method m = e.getClass().getDeclaredMethod("value", new Class[0]);
                            actionParam.getValues().add(m.invoke(e, new Object[0]).toString());
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Failed to populate possible enum parameter values, ignoring...", (Throwable)e);
                    }
                }
                params.getParameter().add(actionParam);
            }
        }
        return params;
    }

    public List<ActionDetail> listActionDetails() {
        Lock readLock = this.actionProcessorsLock.readLock();
        try {
            readLock.lock();
            List<ActionDetail> list = this.actionProcessors.stream().map(x -> x.getActionDetail()).collect(Collectors.toList());
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Deprecated
    protected ActionDetail getActionDetailByActionName(String actionName) {
        for (ActionDetail actionDetail : this.listActionDetails()) {
            if (!actionDetail.getName().equals(actionName)) continue;
            return actionDetail;
        }
        return null;
    }

    public ActionDetail findActionDetail(Action action, FieldType sourceType) throws AtlasException {
        ActionProcessor processor = this.findActionProcessor(action, sourceType);
        if (processor == null) {
            return null;
        }
        return processor.getActionDetail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionProcessor findActionProcessor(Action action, FieldType sourceType) throws AtlasException {
        CustomAction customAction = null;
        if (action instanceof CustomAction && ((customAction = (CustomAction)action).getClassName() == null || customAction.getMethodName() == null)) {
            throw new AtlasException("The class name and method name must be specified for custom FieldAction: " + customAction.getName());
        }
        ArrayList<ActionProcessor> matches = new ArrayList<ActionProcessor>();
        Lock readLock = this.actionProcessorsLock.readLock();
        try {
            readLock.lock();
            for (ActionProcessor processor : this.actionProcessors) {
                if (customAction != null) {
                    ActionDetail detail = processor.getActionDetail();
                    if (!customAction.getClassName().equals(detail.getClassName()) || !customAction.getMethodName().equals(detail.getMethod())) continue;
                    matches.add(processor);
                    break;
                }
                if (processor.getActionClass() != action.getClass()) continue;
                matches.add(processor);
            }
        }
        finally {
            readLock.unlock();
        }
        return this.findBestActionProcessor(matches, sourceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionProcessor findActionProcessor(String name, Object value) {
        FieldType valueType = value != null ? this.getConversionService().fieldTypeFromClass(value.getClass()) : FieldType.NONE;
        String uppercaseName = name.toUpperCase();
        ArrayList<ActionProcessor> processors = new ArrayList<ActionProcessor>();
        Lock readLock = this.actionProcessorsLock.readLock();
        try {
            readLock.lock();
            for (ActionProcessor processor : this.actionProcessors) {
                if (!processor.getActionDetail().getName().toUpperCase().equals(uppercaseName)) continue;
                processors.add(processor);
            }
        }
        finally {
            readLock.unlock();
        }
        return this.findBestActionProcessor(processors, valueType);
    }

    private ActionProcessor findBestActionProcessor(List<ActionProcessor> processors, FieldType valueType) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        if (valueType != null && !Arrays.asList(FieldType.ANY, FieldType.NONE).contains(valueType)) {
            for (ActionProcessor processor : processors) {
                if (!valueType.equals((Object)processor.getActionDetail().getSourceType())) continue;
                return processor;
            }
        }
        return processors.get(0);
    }

    private Object flattenList(Object value) {
        if (value instanceof Iterable) {
            ArrayList extractedValues = new ArrayList();
            for (Object argument : (Iterable)value) {
                if (argument instanceof Iterable) {
                    for (Object item : (Iterable)argument) {
                        extractedValues.add(item);
                    }
                    continue;
                }
                extractedValues.add(argument);
            }
            return extractedValues;
        }
        return value;
    }

    public Object buildAndProcessAction(ActionProcessor actionProcessor, Map<String, Object> actionParameters, List<Field> fields) {
        ArrayList<Object> flattenedValues = new ArrayList<Object>();
        for (Field item : fields) {
            if (item instanceof FieldGroup) {
                FieldGroup fieldGroup = (FieldGroup)item;
                ArrayList<Object> values = new ArrayList<Object>();
                this.extractNestedListValuesFromFieldGroup(fieldGroup, values);
                flattenedValues.addAll(values);
                continue;
            }
            flattenedValues.add(item.getValue());
        }
        ArrayList<Object> sourceObject = flattenedValues;
        if (flattenedValues.size() == 1) {
            sourceObject = flattenedValues.get(0);
        }
        FieldType valueType = this.determineFieldType(flattenedValues);
        try {
            Action action = actionProcessor.getActionClass().newInstance();
            for (Map.Entry<String, Object> property : actionParameters.entrySet()) {
                String setter = "set" + property.getKey().substring(0, 1).toUpperCase() + property.getKey().substring(1);
                action.getClass().getMethod(setter, property.getValue().getClass()).invoke((Object)action, property.getValue());
            }
            return this.processAction(action, actionProcessor, valueType, sourceObject);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The action '%s' cannot be processed", actionProcessor.getActionDetail().getName()), e);
        }
    }

    public Field processActions(AtlasInternalSession session, Field field) throws AtlasException {
        ArrayList actions = field.getActions();
        FieldType targetType = field.getFieldType();
        if (actions == null || actions.isEmpty()) {
            return field;
        }
        if (FieldType.COMPLEX.equals((Object)targetType)) {
            return field;
        }
        ArrayList<Object> sourceObject = field.getValue();
        FieldType sourceType = sourceObject != null ? this.getConversionService().fieldTypeFromClass(sourceObject.getClass()) : FieldType.NONE;
        FieldGroup fieldGroup = null;
        if (field instanceof FieldGroup) {
            fieldGroup = (FieldGroup)field;
            ArrayList<Object> values = new ArrayList<Object>();
            if (this.hasExpressionAction(actions)) {
                this.extractNestedListValuesFromFieldGroup(fieldGroup, values);
                field = this.findLastIndexField(fieldGroup);
            } else {
                this.extractFlatListValuesFromFieldGroup((AtlasSession)session, fieldGroup, values);
            }
            sourceObject = values;
            sourceType = this.determineFieldType(values);
        }
        Object tmpSourceObject = sourceObject;
        FieldType currentType = sourceType;
        block0: for (Action action : actions) {
            ActionProcessor processor = this.findActionProcessor(action, currentType);
            ActionDetail detail = processor.getActionDetail();
            if (detail == null) {
                AtlasUtil.addAudit((AtlasSession)session, field.getDocId(), String.format("Couldn't find metadata for a FieldAction '%s', ignoring...", action.getDisplayName()), field.getPath(), AuditStatus.WARN, null);
                continue;
            }
            tmpSourceObject = this.processAction(action, processor, currentType, tmpSourceObject);
            currentType = null;
            if (tmpSourceObject instanceof List) {
                for (Object item : (List)tmpSourceObject) {
                    if (item == null) continue;
                    currentType = this.conversionService.fieldTypeFromClass(item.getClass());
                    continue block0;
                }
                continue;
            }
            if (tmpSourceObject == null) continue;
            currentType = this.conversionService.fieldTypeFromClass(tmpSourceObject.getClass());
        }
        if (tmpSourceObject instanceof List) {
            fieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)false);
            if (fieldGroup.getCollectionType() == null || CollectionType.NONE.equals((Object)fieldGroup.getCollectionType())) {
                fieldGroup.setCollectionType(CollectionType.ARRAY);
                fieldGroup.setPath(fieldGroup.getPath() + "[]");
            }
            for (Object subValue : (List)tmpSourceObject) {
                SimpleField subField = new SimpleField();
                AtlasModelFactory.copyField((Field)fieldGroup, (Field)subField, (boolean)false);
                subField.setIndex(null);
                subField.setValue(subValue);
                subField.setFieldType(currentType);
                subField.setCollectionType(CollectionType.NONE);
                fieldGroup.getField().add(subField);
            }
            field = fieldGroup;
        } else if (fieldGroup != null) {
            SimpleField newField = new SimpleField();
            AtlasModelFactory.copyField((Field)field, (Field)newField, (boolean)false);
            newField.setValue(tmpSourceObject);
            newField.setFieldType(currentType);
            field = newField;
        } else {
            field.setValue(tmpSourceObject);
            field.setFieldType(currentType);
        }
        return field;
    }

    private FieldType determineFieldType(List<Object> values) {
        Optional<Object> o;
        if (values.size() > 0 && (o = values.stream().filter(v -> v != null).reduce((a, b) -> b)).isPresent()) {
            if (o.get() instanceof List) {
                o = ((List)o.get()).stream().filter(v -> v != null).reduce((a, b) -> b);
            }
            if (o.isPresent()) {
                return this.getConversionService().fieldTypeFromClass(o.get().getClass());
            }
        }
        return FieldType.NONE;
    }

    private void extractFlatListValuesFromFieldGroup(AtlasSession session, FieldGroup fieldGroup, List<Object> values) {
        if (fieldGroup == null || fieldGroup.getField() == null || fieldGroup.getField().isEmpty()) {
            return;
        }
        for (Field subField : fieldGroup.getField()) {
            Integer index = subField.getIndex();
            Object value = null;
            if (subField instanceof FieldGroup) {
                List fields = ((FieldGroup)subField).getField();
                if (fields != null && !fields.isEmpty()) {
                    if (fieldGroup.getField().size() == 1 && (index == 0 || index == null)) {
                        for (Field field : fields) {
                            values.add(field.getValue());
                        }
                        break;
                    }
                    AtlasUtil.addAudit(session, subField.getDocId(), "Using only the first element of the collection since a single value is expected in a multi-field selection.", subField.getPath(), AuditStatus.WARN, null);
                    value = ((Field)fields.get(0)).getValue();
                }
            } else {
                value = subField.getValue();
            }
            if (index != null) {
                while (index >= values.size()) {
                    values.add(null);
                }
                values.set(index, value);
                continue;
            }
            values.add(value);
        }
    }

    private void extractNestedListValuesFromFieldGroup(FieldGroup fieldGroup, List<Object> values) {
        if (fieldGroup == null || fieldGroup.getField() == null || fieldGroup.getField().isEmpty()) {
            return;
        }
        for (Field subField : fieldGroup.getField()) {
            ArrayList<Object> subValue = null;
            if (subField instanceof FieldGroup) {
                ArrayList<Object> subValues = new ArrayList<Object>();
                this.extractNestedListValuesFromFieldGroup((FieldGroup)subField, subValues);
                subValue = subValues;
            } else {
                subValue = subField.getValue();
            }
            Integer index = subField.getIndex();
            if (index != null) {
                while (index >= values.size()) {
                    values.add(null);
                }
                values.set(index, subValue);
                continue;
            }
            values.add(subValue);
        }
    }

    private boolean hasExpressionAction(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof Expression)) continue;
            return true;
        }
        return false;
    }

    private Field findLastIndexField(FieldGroup fieldGroup) {
        Field lastSubField = (Field)fieldGroup.getField().get(0);
        for (Field subField : fieldGroup.getField()) {
            int subFieldIndex = subField.getIndex() == null ? Integer.MAX_VALUE : subField.getIndex();
            int lastSubFieldIndex = lastSubField.getIndex() == null ? Integer.MAX_VALUE : lastSubField.getIndex();
            if (lastSubFieldIndex > subFieldIndex) continue;
            lastSubField = subField;
        }
        return lastSubField;
    }

    private Object processAction(Action action, ActionProcessor processor, FieldType sourceType, Object sourceObject) throws AtlasException {
        Multiplicity multiplicity;
        ActionDetail detail = processor.getActionDetail();
        Multiplicity multiplicity2 = multiplicity = detail.getMultiplicity() != null ? detail.getMultiplicity() : Multiplicity.ONE_TO_ONE;
        if (sourceObject instanceof List) {
            this.convertCollectionValues(sourceObject, detail.getSourceType());
        } else if (!this.isAssignableFieldType(detail.getSourceType(), sourceType)) {
            sourceObject = this.getConversionService().convertType((Object)sourceObject, sourceType, detail.getSourceType());
        }
        if (sourceObject instanceof List && multiplicity != Multiplicity.MANY_TO_ONE) {
            this.processActionForEachCollectionItem(action, processor, sourceObject);
        } else {
            sourceObject = processor.process(action, sourceObject);
        }
        if (sourceObject != null && sourceObject.getClass().isArray()) {
            sourceObject = Arrays.asList((Object[])sourceObject);
        } else if (sourceObject instanceof Collection && !(sourceObject instanceof List)) {
            sourceObject = Arrays.asList(((Collection)sourceObject).toArray());
        }
        return sourceObject;
    }

    private void processActionForEachCollectionItem(Action action, ActionProcessor processor, List<Object> collection) throws AtlasException {
        for (int i = 0; i < collection.size(); ++i) {
            Object subValue = collection.get(i);
            if (subValue instanceof List) {
                this.processActionForEachCollectionItem(action, processor, (List)subValue);
                continue;
            }
            subValue = processor.process(action, subValue);
            collection.set(i, subValue);
        }
    }

    private void convertCollectionValues(List<Object> sourceList, FieldType type) throws AtlasConversionException {
        for (int i = 0; i < sourceList.size(); ++i) {
            FieldType subType;
            Object subValue = sourceList.get(i);
            if (subValue instanceof List) {
                this.convertCollectionValues((List)subValue, type);
                continue;
            }
            FieldType fieldType = subType = subValue != null ? this.getConversionService().fieldTypeFromClass(subValue.getClass()) : FieldType.NONE;
            if (subValue == null || this.isAssignableFieldType(type, subType)) continue;
            subValue = this.getConversionService().convertType(subValue, subType, type);
            sourceList.set(i, subValue);
        }
    }

    private boolean isAssignableFieldType(FieldType expected, FieldType actual) {
        if (FieldType.ANY.equals((Object)expected)) {
            return true;
        }
        if (FieldType.ANY_DATE.equals((Object)expected)) {
            return FieldType.DATE.equals((Object)actual) || FieldType.TIME.equals((Object)actual) || FieldType.DATE_TIME.equals((Object)actual) || FieldType.DATE_TIME_TZ.equals((Object)actual) || FieldType.DATE_TZ.equals((Object)actual) || FieldType.TIME_TZ.equals((Object)actual);
        }
        return expected.equals((Object)actual);
    }

    public AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    private String camelize(String parameter) {
        if (parameter == null || parameter.length() == 0) {
            return parameter;
        }
        char[] c = parameter.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static {
        listClasses = new HashSet<String>(Arrays.asList("java.util.List", "java.util.ArrayList", "java.util.LinkedList", "java.util.Vector", "java.util.Stack", "java.util.AbstractList", "java.util.AbstractSequentialList"));
        mapClasses = new HashSet<String>(Arrays.asList("java.util.Map", "java.util.HashMap", "java.util.TreeMap", "java.util.Hashtable", "java.util.IdentityHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap", "java.util.SortedMap", "java.util.WeakHashMap", "java.util.Properties", "java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentMap"));
    }

    static interface ActionProcessor {
        public ActionDetail getActionDetail();

        public Class<? extends Action> getActionClass();

        public Object process(Action var1, Object var2) throws AtlasException;
    }
}

