/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasFunctionResolver;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.FunctionResolver;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.SimpleField;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasExpressionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasExpressionProcessor.class);

    public static void processExpression(DefaultAtlasSession session, String expression) {
        block8: {
            if (expression == null || expression.trim().isEmpty()) {
                return;
            }
            try {
                Expression parsedExpression;
                Field answer;
                HashMap<String, Field> sourceFieldMap = new HashMap<String, Field>();
                Field parent = session.head().getSourceField();
                if (parent != null && !AtlasUtil.isEmpty(parent.getDocId()) && !AtlasUtil.isEmpty(parent.getPath())) {
                    sourceFieldMap.put(parent.getDocId() + ":" + parent.getPath(), parent);
                }
                if (parent instanceof FieldGroup && AtlasUtil.isEmpty(parent.getPath())) {
                    FieldGroup parentGroup = (FieldGroup)FieldGroup.class.cast(parent);
                    for (Field child : parentGroup.getField()) {
                        if (AtlasUtil.isEmpty(child.getDocId()) && AtlasUtil.isEmpty(child.getPath())) continue;
                        sourceFieldMap.put(child.getDocId() + ":" + child.getPath(), child);
                    }
                }
                if ((answer = (parsedExpression = Expression.parse((String)expression, (FunctionResolver)DefaultAtlasFunctionResolver.getInstance())).evaluate(path -> {
                    if (path == null || path.isEmpty()) {
                        return null;
                    }
                    try {
                        String[] splitted = path.split(":", 2);
                        AtlasFieldReader reader = session.getFieldReader(splitted[0]);
                        Field f = (Field)sourceFieldMap.get(path);
                        if (f == null) {
                            return null;
                        }
                        session.head().setSourceField(f);
                        return reader.read((AtlasInternalSession)session);
                    }
                    catch (Exception e) {
                        throw new ExpressionException((Throwable)e);
                    }
                })) instanceof Field) {
                    session.head().setSourceField(answer);
                } else {
                    Field from = session.head().getSourceField();
                    SimpleField to = new SimpleField();
                    AtlasModelFactory.copyField((Field)from, (Field)to, (boolean)false);
                    to.setValue((Object)answer);
                    session.head().setSourceField((Field)to);
                }
            }
            catch (Exception e) {
                AtlasUtil.addAudit((AtlasSession)session, null, String.format("Expression processing error: %s", e.getMessage()), expression, AuditStatus.ERROR, null);
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("", (Throwable)e);
            }
        }
    }
}

