/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasSession;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasUtil {
    public static final int SPLIT_LIMIT = 4;
    public static final String NEW_LINE_CHARS = "(?m)$^|[\\r\\n]+\\z";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasUtil.class);

    public static Properties loadPropertiesFromURL(URL url) throws Exception {
        try (InputStream is = url.openStream();){
            Properties prop = new Properties();
            prop.load(is);
            Properties properties = prop;
            return properties;
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.matches("^\\s+$");
    }

    public static boolean matchUriModule(String uriA, String uriB) {
        if (uriA == null || uriB == null) {
            return false;
        }
        if (AtlasUtil.getUriModule(uriA) == null || AtlasUtil.getUriModule(uriB) == null) {
            return false;
        }
        return AtlasUtil.getUriModule(uriA).equalsIgnoreCase(AtlasUtil.getUriModule(uriB));
    }

    protected static void validateUri(String atlasUri) {
        if (!atlasUri.startsWith("atlas:")) {
            throw new IllegalStateException("Invalid atlas uri " + atlasUri + " does not begin with 'atlas:': " + atlasUri);
        }
        if (AtlasUtil.countCharacters(atlasUri, '?') > 1) {
            throw new IllegalStateException("Invalid atlas uri " + atlasUri + " multiple '?' characters: " + atlasUri);
        }
    }

    protected static List<String> getUriPartsAsArray(String atlasUri) {
        if (atlasUri == null) {
            return null;
        }
        if (AtlasUtil.isEmpty(atlasUri)) {
            return Arrays.asList(new String[0]);
        }
        AtlasUtil.validateUri(atlasUri);
        String[] pass1 = null;
        if (atlasUri.contains("?")) {
            pass1 = atlasUri.split("\\?", 2);
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (pass1 != null && pass1.length >= 1) {
            parts.addAll(Arrays.asList(pass1[0].split(":", 4)));
        } else {
            parts.addAll(Arrays.asList(atlasUri.split(":", 4)));
        }
        return parts;
    }

    public static String getUriScheme(String atlasUri) {
        List<String> uriA = AtlasUtil.getUriPartsAsArray(atlasUri);
        if (uriA == null || uriA.size() < 1 || AtlasUtil.isEmpty(uriA.get(0))) {
            return null;
        }
        return uriA.get(0);
    }

    public static String getUriModule(String atlasUri) {
        List<String> uriA = AtlasUtil.getUriPartsAsArray(atlasUri);
        if (uriA == null || uriA.size() < 2 || AtlasUtil.isEmpty(uriA.get(1))) {
            return null;
        }
        return uriA.get(1);
    }

    public static String getUriDataType(String atlasUri) {
        List<String> uriA = AtlasUtil.getUriPartsAsArray(atlasUri);
        if (uriA == null || uriA.size() < 3 || AtlasUtil.isEmpty(uriA.get(2))) {
            return null;
        }
        return uriA.get(2);
    }

    public static String getUriModuleVersion(String atlasUri) {
        List<String> uriA = AtlasUtil.getUriPartsAsArray(atlasUri);
        if (uriA == null || uriA.size() < 4 || AtlasUtil.isEmpty(uriA.get(3))) {
            return null;
        }
        return uriA.get(3);
    }

    public static String getUriParameterValue(String atlasUri, String key) {
        Map<String, String> params = AtlasUtil.getUriParameters(atlasUri);
        if (params == null || params.isEmpty()) {
            return null;
        }
        return params.get(key);
    }

    public static Map<String, String> getUriParameters(String atlasUri) {
        if (atlasUri == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (AtlasUtil.isEmpty(atlasUri)) {
            return params;
        }
        AtlasUtil.validateUri(atlasUri);
        String[] pass1 = null;
        if (atlasUri.contains("?")) {
            pass1 = atlasUri.split("\\?", 2);
        }
        if (pass1 == null || pass1.length < 2 || pass1[1] == null || pass1[1].length() < 1) {
            return params;
        }
        String allParams = null;
        try {
            allParams = URLDecoder.decode(pass1[1], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to parse uri" + atlasUri + " for configuration parameters", (Throwable)e);
            return params;
        }
        if (allParams == null) {
            return null;
        }
        String[] configs = allParams.split("&", 4);
        if (configs == null || configs.length < 1) {
            return params;
        }
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].contains("=")) {
                LOG.warn("Invalid configuration parameter: " + configs[i] + " for uri: '" + atlasUri + "'");
                continue;
            }
            String[] cfgs = configs[i].split("=");
            if (cfgs == null || cfgs.length != 2) {
                LOG.warn("Invalid configuration parameter: " + configs[i] + " for uri: '" + atlasUri + "'");
                continue;
            }
            params.put(cfgs[0], cfgs[1]);
        }
        return params;
    }

    public static int countCharacters(String text, char match) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != match) continue;
            ++count;
        }
        return count;
    }

    public static List<Class<?>> findClassesForPackage(String scannedPackage) {
        String scannedPath = scannedPackage.replace('.', '/');
        URL scannedUrl = AtlasUtil.getResource(scannedPath);
        if (scannedUrl == null) {
            throw new IllegalArgumentException(String.format("Unable to detect resources for url='%s' for package='%s'", scannedPath, scannedPackage));
        }
        if ("jar".equals(scannedUrl.getProtocol())) {
            return AtlasUtil.findClassesFromJar(scannedUrl);
        }
        File scannedFd = new File(scannedUrl.getFile());
        ArrayList classes = new ArrayList();
        if (scannedFd.listFiles() == null) {
            return classes;
        }
        for (File file : scannedFd.listFiles()) {
            classes.addAll(AtlasUtil.find(file, scannedPackage));
        }
        return classes;
    }

    public static void addAudit(AtlasSession session, String docId, String message, String path, AuditStatus status, String value) {
        String docName = session != null ? AtlasUtil.getDocumentNameById(session.getMapping(), docId) : null;
        session.getAudits().getAudit().add(AtlasUtil.createAudit(status, docId, docName, path, value, message));
    }

    public static Audit createAudit(AuditStatus status, String docId, String docName, String path, String value, String message) {
        Audit audit = new Audit();
        audit.setDocId(docId);
        audit.setDocName(docName);
        audit.setMessage(message);
        audit.setPath(path);
        audit.setStatus(status);
        audit.setValue(value);
        return audit;
    }

    public static void addAudit(AtlasSession session, Validation validation) {
        Audit audit = new Audit();
        audit.setDocId(validation.getDocId());
        audit.setDocName(validation.getDocName());
        audit.setMessage(validation.getMessage());
        audit.setStatus(AtlasUtil.toAuditStatus(validation.getStatus()));
        session.getAudits().getAudit().add(audit);
    }

    public static void addAudits(AtlasInternalSession session, String docId, List<Audit> audits) {
        for (Audit audit : audits) {
            audit.setDocId(docId);
            audit.setDocName(AtlasUtil.getDocumentNameById(session.getMapping(), docId));
            session.getAudits().getAudit().add(audit);
        }
    }

    public static AuditStatus toAuditStatus(ValidationStatus vstatus) {
        switch (vstatus) {
            case ERROR: {
                return AuditStatus.ERROR;
            }
            case WARN: {
                return AuditStatus.WARN;
            }
            case INFO: {
                return AuditStatus.INFO;
            }
            case ALL: {
                return AuditStatus.ALL;
            }
            case NONE: {
                return AuditStatus.NONE;
            }
        }
        return null;
    }

    public static String getDocumentNameById(AtlasMapping mapping, String docId) {
        if (mapping == null) {
            return null;
        }
        Optional<DataSource> found = mapping.getDataSource().stream().filter(ds -> docId == null && ds.getId() == null || docId != null && docId.equals(ds.getId())).findFirst();
        return found.isPresent() ? found.get().getName() : null;
    }

    protected static URL getResource(String scannedPath) {
        URL url = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = AtlasUtil.class.getClassLoader();
        }
        if (classLoader != null && (url = classLoader.getResource(scannedPath)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(scannedPath);
    }

    protected static List<Class<?>> find(File file, String scannedPackage) {
        ArrayList classes;
        block4: {
            String resource;
            block3: {
                classes = new ArrayList();
                resource = scannedPackage + '.' + file.getName();
                if (!file.isDirectory()) break block3;
                for (File child : file.listFiles()) {
                    classes.addAll(AtlasUtil.find(child, resource));
                }
                break block4;
            }
            if (!resource.endsWith(".class")) break block4;
            int endIndex = resource.length() - ".class".length();
            String className = resource.substring(0, endIndex);
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classes;
    }

    protected static List<Class<?>> findClassesFromJar(URL jarFileUrl) {
        ArrayList classNames = new ArrayList();
        JarURLConnection connection = null;
        try {
            connection = (JarURLConnection)jarFileUrl.openConnection();
        }
        catch (IOException e) {
            LOG.warn(String.format("Unable to load classes from jar file=%s msg=%s", jarFileUrl, e.getMessage()), (Throwable)e);
            return classNames;
        }
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(new File(connection.getJarFileURL().toURI())));){
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                    String className = entry.getName().replace('/', '.');
                    className = className.substring(0, className.length() - ".class".length());
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = AtlasUtil.class.getClassLoader();
                    }
                    try {
                        Class<?> clazz = Class.forName(className, false, classLoader);
                        classNames.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn(String.format("Unable to load class=%s from jar file=%s msg=%s", className, jarFileUrl, e.getMessage()), (Throwable)e);
                    }
                }
                entry = zip.getNextEntry();
            }
        }
        catch (IOException | URISyntaxException e) {
            LOG.warn(String.format("Unable to load classes from jar file=%s msg=%s", jarFileUrl, e.getMessage()), (Throwable)e);
        }
        return classNames;
    }

    public static String getChainedMessage(Throwable t) {
        StringBuilder buf = new StringBuilder();
        buf.append(t.getMessage());
        Throwable target = t;
        while ((target = target.getCause()) != null) {
            if (target.getMessage() == null || target.getMessage().isEmpty()) continue;
            buf.append(" - ");
            buf.append(target.getMessage());
        }
        return buf.toString();
    }

    public static String escapeForUri(String source) {
        if (source == null) {
            return null;
        }
        return source.replaceAll(Pattern.quote("!"), "%21").replaceAll(Pattern.quote("#"), "%23").replaceAll(Pattern.quote("$"), "%24").replaceAll(Pattern.quote("&"), "%26").replaceAll(Pattern.quote("'"), "%27").replaceAll(Pattern.quote("("), "%28").replaceAll(Pattern.quote(")"), "%29").replaceAll(Pattern.quote("*"), "%2A").replaceAll(Pattern.quote("+"), "%2B").replaceAll(Pattern.quote(","), "%2C").replaceAll(Pattern.quote("/"), "%2F").replaceAll(Pattern.quote(":"), "%3A").replaceAll(Pattern.quote(";"), "%3B").replaceAll(Pattern.quote("="), "%3D").replaceAll(Pattern.quote("?"), "%3F").replaceAll(Pattern.quote("@"), "%40").replaceAll(Pattern.quote("["), "%5B").replaceAll(Pattern.quote("]"), "%5D");
    }

    public static String unescapeFromUri(String uri) {
        if (uri == null) {
            return null;
        }
        return uri.replaceAll("%21", "!").replaceAll("%23", "#").replaceAll("%24", "$").replaceAll("%26", "&").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2A", "*").replaceAll("%2B", "+").replaceAll("%2C", ",").replaceAll("%2F", "/").replaceAll("%3A", ":").replaceAll("%3B", ";").replaceAll("%3D", "=").replaceAll("%3F", "?").replaceAll("%40", "@").replaceAll("%5B", "[").replaceAll("%5D", "]");
    }

    public static void deleteDirectory(File targetDir) {
        File[] allContents = targetDir.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                if (!file.isDirectory()) {
                    file.delete();
                    continue;
                }
                AtlasUtil.deleteDirectory(file);
            }
        }
        targetDir.delete();
    }

    public static void deleteDirectoryContents(File targetDir) {
        File[] allContents = targetDir.listFiles();
        if (allContents != null) {
            for (File element : allContents) {
                if (element.isFile()) {
                    element.delete();
                    continue;
                }
                if (!element.isDirectory()) continue;
                AtlasUtil.deleteDirectory(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(Path sourcePath, Path destPath) throws IOException {
        File source = new File(sourcePath.toString());
        File dest = new File(destPath.toString());
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

