/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.regex.Pattern;

public class StringConverter
implements AtlasConverter<String> {
    private static final Pattern TRUE_PATTERN = Pattern.compile("true|t|yes|y", 2);

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.DECIMAL, concerns={AtlasConversionConcern.FORMAT})
    public BigDecimal toBigDecimal(String value) throws AtlasConversionException {
        try {
            return value != null ? new BigDecimal(value) : null;
        }
        catch (NumberFormatException e) {
            throw new AtlasConversionException(String.format("String %s cannont be converted to a BigDecimal as it is not in a valid format", value));
        }
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.BIG_INTEGER, concerns={AtlasConversionConcern.FORMAT})
    public BigInteger toBigInteger(String value) throws AtlasConversionException {
        try {
            return value != null ? new BigInteger(value) : null;
        }
        catch (NumberFormatException e) {
            throw new AtlasConversionException(String.format("String %s cannont be converted to a BigInteger as it is not in a valid format", value));
        }
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean toBoolean(String value, String sourceFormat, String targetFormat) {
        if (value == null) {
            return null;
        }
        Pattern pattern = sourceFormat != null && !sourceFormat.isEmpty() ? Pattern.compile(sourceFormat, 2) : TRUE_PATTERN;
        if (pattern.matcher(value).matches()) {
            return Boolean.TRUE;
        }
        try {
            Number n = NumberFormat.getInstance().parse(value);
            if (n.intValue() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (ParseException e) {
            e.getMessage();
            return Boolean.FALSE;
        }
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.FORMAT, AtlasConversionConcern.FRACTIONAL_PART})
    public Byte toByte(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException nfex) {
            try {
                BigDecimal bd = new BigDecimal(value);
                if (bd.compareTo(new BigDecimal(-128)) < 0 || bd.compareTo(new BigDecimal(127)) > 0) {
                    throw new AtlasConversionException(String.format("String %s is greater than Byte.MAX_VALUE  or less than Byte.MIN_VALUE", value));
                }
                return bd.byteValue();
            }
            catch (NumberFormatException nfe2) {
                throw new AtlasConversionException(String.format("String %s cannont be converted to a Byte as it is not in a numerical format", value));
            }
        }
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE})
    public Character toCharacter(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.isEmpty() || value.length() > 1) {
            throw new AtlasConversionException(String.format("String '%s' is either empty or greater than one character long", value));
        }
        if (value.charAt(0) < '\u0000' || value.charAt(0) > '\uffff') {
            throw new AtlasConversionException(String.format("String %s is greater than Character.MAX_VALUE  or less than Character.MIN_VALUE", value));
        }
        return Character.valueOf(value.charAt(0));
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.DATE_TIME)
    public Date toDate(String date, String sourceFormat, String targetFormat) {
        DateTimeFormatter formater = sourceFormat != null ? DateTimeFormatter.ofPattern(sourceFormat) : DateTimeFormatter.ISO_ZONED_DATE_TIME;
        return Date.from(ZonedDateTime.parse(date, formater).toInstant());
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.DOUBLE, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE})
    public Double toDouble(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new AtlasConversionException((Throwable)nfe);
        }
        if (Double.valueOf(value) == 0.0 || Double.valueOf(value) == -0.0) {
            return Double.valueOf(value);
        }
        if (Double.valueOf(value) < Double.MIN_VALUE || Double.valueOf(value) > Double.MAX_VALUE) {
            throw new AtlasConversionException(String.format("String %s is greater than Double.MAX_VALUE  or less than Double.MIN_VALUE", value));
        }
        return Double.valueOf(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.FLOAT, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE})
    public Float toFloat(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            throw new AtlasConversionException((Throwable)nfe);
        }
        BigDecimal bd = new BigDecimal(value);
        if (bd.floatValue() == 0.0f || (double)bd.floatValue() == -0.0) {
            return Float.valueOf(value);
        }
        if (bd.floatValue() < Float.MIN_VALUE || bd.floatValue() > Float.MAX_VALUE) {
            throw new AtlasConversionException(String.format("String %s is greater than Float.MAX_VALUE  or less than Float.MIN_VALUE", value));
        }
        return Float.valueOf(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public Integer toInteger(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Integer i = null;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            try {
                BigDecimal bd = new BigDecimal(value);
                if (bd.compareTo(new BigDecimal(Integer.MIN_VALUE)) < 0 || bd.compareTo(new BigDecimal(Integer.MAX_VALUE)) > 0) {
                    throw new AtlasConversionException(String.format("String %s is greater than Integer.MAX_VALUE  or less than Integer.MIN_VALUE", value));
                }
                i = bd.intValue();
            }
            catch (NumberFormatException nfe2) {
                throw new AtlasConversionException((Throwable)nfe);
            }
        }
        return i;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.DATE)
    public LocalDate toLocalDate(String value) {
        return value != null ? LocalDate.parse(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.TIME)
    public LocalTime toLocalTime(String value) {
        return value != null ? LocalTime.parse(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(String value) {
        return value != null ? LocalDateTime.parse(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.LONG, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public Long toLong(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long l = null;
        try {
            l = Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            try {
                BigDecimal bd = new BigDecimal(value);
                if (bd.compareTo(new BigDecimal(Long.MIN_VALUE)) < 0 || bd.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    throw new AtlasConversionException(String.format("String %s is greater than Long.MAX_VALUE  or less than Long.MIN_VALUE", value));
                }
                l = bd.longValue();
            }
            catch (NumberFormatException nfe2) {
                throw new AtlasConversionException((Throwable)nfe);
            }
        }
        return l;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public Short toShort(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Short shortty = null;
        try {
            shortty = Short.parseShort(value);
        }
        catch (NumberFormatException nfe) {
            try {
                BigDecimal bd = new BigDecimal(value);
                if (bd.compareTo(new BigDecimal(Short.MIN_VALUE)) < 0 || bd.compareTo(new BigDecimal(Short.MAX_VALUE)) > 0) {
                    throw new AtlasConversionException(String.format("String %s is greater than Short.MAX_VALUE  or less than Short.MIN_VALUE", value));
                }
                shortty = bd.shortValue();
            }
            catch (NumberFormatException nfe2) {
                throw new AtlasConversionException((Throwable)nfe2);
            }
        }
        return shortty;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.STRING)
    public String toString(String value, String sourceFormat, String targetFormat) {
        if (value == null) {
            return null;
        }
        return new String(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.NUMBER, concerns={AtlasConversionConcern.FORMAT})
    public Number toNumber(String value) throws AtlasConversionException {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if (value.matches("\\d+")) {
            return new BigInteger(value);
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new AtlasConversionException((Throwable)e);
        }
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(String value) {
        return value != null ? ZonedDateTime.parse(value) : null;
    }
}

