/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.BigDecimalConverter;
import io.atlasmap.converters.BigIntegerConverter;
import io.atlasmap.converters.ByteConverter;
import io.atlasmap.converters.DoubleConverter;
import io.atlasmap.converters.FloatConverter;
import io.atlasmap.converters.IntegerConverter;
import io.atlasmap.converters.LongConverter;
import io.atlasmap.converters.ShortConverter;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;

public class NumberConverter
implements AtlasConverter<Number> {
    private BigDecimalConverter bigDecimalConverter = new BigDecimalConverter();
    private BigIntegerConverter bigIntegerConverter = new BigIntegerConverter();
    private ByteConverter byteConverter = new ByteConverter();
    private DoubleConverter doubleConverter = new DoubleConverter();
    private FloatConverter floatConverter = new FloatConverter();
    private IntegerConverter integerConverter = new IntegerConverter();
    private LongConverter longConverter = new LongConverter();
    private ShortConverter shortConverter = new ShortConverter();

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(Number value) throws AtlasConversionException {
        return this.invoke(value, BigDecimal.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(Number value) throws AtlasConversionException {
        return this.invoke(value, BigInteger.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.BOOLEAN)
    public Boolean toBoolean(Number value) throws AtlasConversionException {
        return this.invoke(value, Boolean.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.BYTE)
    public Byte toByte(Number value) throws AtlasConversionException {
        return this.invoke(value, Byte.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.CHAR)
    public Character toCharacter(Number value) throws AtlasConversionException {
        return this.invoke(value, Character.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.DATE_TIME)
    public Date toDate(Number value) throws AtlasConversionException {
        return this.invoke(value, Date.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.DOUBLE)
    public Double toDouble(Number value) throws AtlasConversionException {
        return this.invoke(value, Double.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.FLOAT)
    public Float toFloat(Number value) throws AtlasConversionException {
        return this.invoke(value, Float.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.INTEGER)
    public Integer toInteger(Number value) throws AtlasConversionException {
        return this.invoke(value, Integer.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.DATE)
    public LocalDate toLocalDate(Number value) throws AtlasConversionException {
        return this.invoke(value, LocalDate.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.TIME)
    public LocalTime toLocalTime(Number value) throws AtlasConversionException {
        return this.invoke(value, LocalTime.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(Number value) throws AtlasConversionException {
        return this.invoke(value, LocalDateTime.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.LONG)
    public Long toLong(Number value) throws AtlasConversionException {
        return this.invoke(value, Long.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER)
    public Number toNumber(Number value) {
        return value;
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.SHORT)
    public Short toShort(Number value) throws AtlasConversionException {
        return this.invoke(value, Short.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.STRING)
    public String toString(Number value) throws AtlasConversionException {
        return this.invoke(value, String.class);
    }

    @AtlasConversionInfo(sourceType=FieldType.NUMBER, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(Number value) throws AtlasConversionException {
        return this.invoke(value, ZonedDateTime.class);
    }

    private <T> T invoke(Number object, Class<T> returnType) throws AtlasConversionException {
        if (object == null) {
            return null;
        }
        if (returnType.isInstance(object)) {
            return returnType.cast(object);
        }
        try {
            if (object instanceof BigDecimal) {
                Method m = this.bigDecimalConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.bigDecimalConverter, object));
            }
            if (object instanceof BigInteger) {
                Method m = this.bigIntegerConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.bigIntegerConverter, object));
            }
            if (object instanceof Byte) {
                Method m = this.byteConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.byteConverter, object));
            }
            if (object instanceof Double) {
                Method m = this.doubleConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.doubleConverter, object));
            }
            if (object instanceof Float) {
                Method m = this.floatConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.floatConverter, object));
            }
            if (object instanceof Integer) {
                Method m = this.integerConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.integerConverter, object));
            }
            if (object instanceof Long) {
                Method m = this.longConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.longConverter, object));
            }
            if (object instanceof Short) {
                Method m = this.shortConverter.getClass().getDeclaredMethod("to" + returnType.getSimpleName(), object.getClass());
                return returnType.cast(m.invoke((Object)this.shortConverter, object));
            }
            throw new AtlasConversionException(String.format("Unsupported Number type '%s'", object.getClass().getName()));
        }
        catch (Exception e) {
            throw new AtlasConversionException(String.format("No converter found from='%s' to='%s'", object.getClass().getName(), returnType.getName()));
        }
    }
}

