/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CharacterConverter
implements AtlasConverter<Character> {
    private static final String TRUE_REGEX = "t|T|y|Y|[1-9]";

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(Character value) {
        return value != null ? BigDecimal.valueOf(value.charValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(Character value) {
        return value != null ? BigInteger.valueOf(value.charValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean toBoolean(Character value, String sourceFormat, String targetFormat) {
        String regex;
        if (value == null) {
            return null;
        }
        String string = regex = sourceFormat != null && !"".equals(sourceFormat) ? sourceFormat : TRUE_REGEX;
        if (Character.toString(value.charValue()).matches(regex)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte toByte(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.charValue() > '\u007f') {
            throw new AtlasConversionException(String.format("Character value %s is greater than BYTE.MAX_VALUE", value));
        }
        return (byte)value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.CHAR)
    public Character toCharacter(Character value) {
        if (value == null) {
            return null;
        }
        return new Character(value.charValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.DOUBLE)
    public Double toDouble(Character value) {
        if (value == null) {
            return null;
        }
        return value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.FLOAT)
    public Float toFloat(Character value) {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.charValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.INTEGER)
    public Integer toInteger(Character value) {
        if (value == null) {
            return null;
        }
        return value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.LONG)
    public Long toLong(Character value) {
        if (value == null) {
            return null;
        }
        return value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.NUMBER)
    public Number toNumber(Character value) {
        if (value == null) {
            return null;
        }
        return (int)value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Short toShort(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.charValue() > Short.MAX_VALUE) {
            throw new AtlasConversionException();
        }
        return (short)value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.STRING)
    public String toString(Character value, String sourceFormat, String targetFormat) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

