/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.csv.module;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.csv.core.CsvConfig;
import io.atlasmap.csv.core.CsvFieldReader;
import io.atlasmap.csv.core.CsvFieldWriter;
import io.atlasmap.csv.v2.CsvField;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasModuleDetail(name="CsvModule", uri="atlas:csv", modes={"SOURCE", "TARGET"}, dataFormats={"csv"}, configPackages={"io.atlasmap.csv.v2"})
public class CsvModule
extends BaseAtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(CsvModule.class);

    public void processPreValidation(AtlasInternalSession session) throws AtlasException {
    }

    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        Object sourceDocument = session.getSourceDocument(this.getDocId());
        InputStream sourceInputStream = null;
        if (sourceDocument == null || !(sourceDocument instanceof String) && !(sourceDocument instanceof InputStream)) {
            AtlasUtil.addAudit((AtlasSession)session, (String)this.getDocId(), (String)String.format("Null, non-String or non-Stream source document: docId='%s'", this.getDocId()), null, (AuditStatus)AuditStatus.WARN, null);
        } else if (sourceDocument instanceof String) {
            String sourceDocumentString = (String)String.class.cast(sourceDocument);
            sourceInputStream = new ByteArrayInputStream(sourceDocumentString.getBytes());
        } else {
            sourceInputStream = (InputStream)sourceDocument;
        }
        CsvConfig csvConfig = CsvConfig.newConfig((Map)this.getUriParameters());
        CsvFieldReader reader = new CsvFieldReader(csvConfig);
        reader.setDocument(sourceInputStream);
        session.setFieldReader(this.getDocId(), (AtlasFieldReader)reader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreSourceExecution completed", (Object)this.getDocId());
        }
    }

    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        CsvConfig csvConfig = CsvConfig.newConfig((Map)this.getUriParameters());
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        session.setFieldWriter(this.getDocId(), (AtlasFieldWriter)writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreTargetExcution completed", (Object)this.getDocId());
        }
    }

    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        CsvFieldReader reader = (CsvFieldReader)session.getFieldReader(this.getDocId(), CsvFieldReader.class);
        if (reader == null) {
            AtlasUtil.addAudit((AtlasSession)session, (String)sourceField.getDocId(), (String)String.format("Source document '%s' doesn't exist", this.getDocId()), (String)sourceField.getPath(), (AuditStatus)AuditStatus.ERROR, null);
            return;
        }
        reader.read(session);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processSourceFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue()});
        }
    }

    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        CsvFieldWriter writer = (CsvFieldWriter)session.getFieldWriter(this.getDocId(), CsvFieldWriter.class);
        writer.write(session);
    }

    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
        session.removeFieldReader(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostSourceExecution completed", (Object)this.getDocId());
        }
    }

    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        CsvFieldWriter writer = (CsvFieldWriter)session.getFieldWriter(this.getDocId(), CsvFieldWriter.class);
        if (writer != null && writer.getDocument() != null) {
            String targetDocumentString = writer.toCsv();
            session.setTargetDocument(this.getDocId(), (Object)targetDocumentString);
        } else {
            AtlasUtil.addAudit((AtlasSession)session, (String)this.getDocId(), (String)String.format("No target document created for DataSource:[id=%s, uri=%s]", this.getDocId(), this.getUri()), null, (AuditStatus)AuditStatus.WARN, null);
        }
        session.removeFieldWriter(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostTargetExecution completed", (Object)this.getDocId());
        }
    }

    public Field cloneField(Field field) throws AtlasException {
        return CsvField.cloneOf((CsvField)((CsvField)field));
    }

    public Boolean isSupportedField(Field field) {
        return field instanceof CsvField || field instanceof FieldGroup;
    }
}

