/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.ValidationScope;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.StringPatternValidator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class StringPatternValidatorTest
extends BaseValidatorTest {
    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        this.validator = new StringPatternValidator(ValidationScope.ALL, "Must match .*", ".*");
        Assert.assertTrue((boolean)this.validator.supports(String.class));
    }

    @Test
    public void testUnsupported() {
        this.validator = new StringPatternValidator(ValidationScope.DATA_SOURCE, "Must match [0-9_.]", "[0-9_.]");
        Assert.assertFalse((boolean)this.validator.supports(Double.class));
    }

    @Test
    public void testValidate() {
        this.validator = new StringPatternValidator(ValidationScope.MAPPING, "Must match [^A-Za-z0-9_.]", "[^A-Za-z0-9_.]");
        this.validator.validate((Object)"This. &* should result in an error", this.validations, "testValidate");
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        this.validations.clear();
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        this.validator.validate((Object)"This_isafineexample.whatever1223", this.validations, "testValidate-2");
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateUsingMatch() {
        this.validator = new StringPatternValidator(ValidationScope.LOOKUP_TABLE, "Must match [0-9]+", "[0-9]+", true);
        this.validator.validate((Object)"0333", this.validations, "testValidateUsingMatch");
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        this.validator = new StringPatternValidator(ValidationScope.PROPERTY, "Must match [0-9]", "[0-9]", true);
        this.validator.validate((Object)"This_isafineexample.whatever", this.validations, "testValidateUsingMatch-2");
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
    }
}

