/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasUtil;
import io.atlasmap.v2.ValidationStatus;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class AtlasUtilTest {
    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)AtlasUtil.isEmpty(null));
        Assert.assertTrue((boolean)AtlasUtil.isEmpty((String)""));
        Assert.assertTrue((boolean)AtlasUtil.isEmpty((String)"     "));
        Assert.assertTrue((boolean)AtlasUtil.isEmpty((String)"\n\n"));
        Assert.assertTrue((boolean)AtlasUtil.isEmpty((String)"\t\t"));
        Assert.assertTrue((boolean)AtlasUtil.isEmpty((String)"\r\n"));
        Assert.assertTrue((boolean)AtlasUtil.isEmpty((String)"\f\t\n\r"));
        Assert.assertFalse((boolean)AtlasUtil.isEmpty((String)"\b"));
    }

    @Test
    public void testAtlasUri() {
        Map params;
        String uriJavaNover = "atlas:java";
        String uriJavaNoverWParm = "atlas:java?foo=bar";
        String uriJavaNoverWParms = "atlas:java?foo=bar&bar=blah";
        String uriJavaVer1 = "atlas:java::1";
        String uriJavaVer2 = "atlas:java::2";
        String uriJavaVer2WParm = "atlas:java::2?foo=bar";
        String uriJavaVer2WParams = "atlas:java::2?foo=bar&bar=blah";
        List<String> javaUris = Arrays.asList(uriJavaNover, uriJavaNoverWParm, uriJavaNoverWParms, uriJavaVer1, uriJavaVer2, uriJavaVer2WParm, uriJavaVer2WParams);
        List<String> noverUris = Arrays.asList(uriJavaNover, uriJavaNoverWParm, uriJavaNoverWParms);
        List<String> javaVer1Uris = Arrays.asList(uriJavaVer1);
        List<String> javaVer2Uris = Arrays.asList(uriJavaVer2, uriJavaVer2WParm, uriJavaVer2WParams);
        List<String> parmUris = Arrays.asList(uriJavaNoverWParm, uriJavaVer2WParm);
        List<String> parmsUris = Arrays.asList(uriJavaNoverWParms, uriJavaVer2WParams);
        for (String uri : javaUris) {
            Assert.assertEquals((Object)"atlas", (Object)AtlasUtil.getUriScheme((String)uri));
        }
        for (String uri : javaUris) {
            Assert.assertEquals((Object)"java", (Object)AtlasUtil.getUriModule((String)uri));
        }
        for (String uri : javaUris) {
            Assert.assertNull((Object)AtlasUtil.getUriDataType((String)uri));
        }
        for (String uri : noverUris) {
            Assert.assertNull((Object)AtlasUtil.getUriModuleVersion((String)uri));
        }
        for (String uri : javaVer1Uris) {
            Assert.assertEquals((Object)"1", (Object)AtlasUtil.getUriModuleVersion((String)uri));
        }
        for (String uri : javaVer2Uris) {
            Assert.assertEquals((Object)"2", (Object)AtlasUtil.getUriModuleVersion((String)uri));
        }
        for (String uri : parmUris) {
            params = AtlasUtil.getUriParameters((String)uri);
            Assert.assertNotNull((Object)params);
            Assert.assertEquals((Object)1, (Object)params.size());
            Assert.assertEquals((Object)"bar", params.get("foo"));
            Assert.assertNull(params.get("bar"));
        }
        for (String uri : parmsUris) {
            params = AtlasUtil.getUriParameters((String)uri);
            Assert.assertNotNull((Object)params);
            Assert.assertEquals((Object)2, (Object)params.size());
            Assert.assertEquals((Object)"bar", params.get("foo"));
            Assert.assertEquals((Object)"blah", params.get("bar"));
            Assert.assertNull(params.get("blah"));
        }
    }

    @Test
    public void testFindClassesForPackage() {
        List classes = AtlasUtil.findClassesForPackage((String)"io.atlasmap.v2");
        Assert.assertNotNull((Object)classes);
        Assert.assertTrue((boolean)classes.stream().map(Class::getName).collect(Collectors.toList()).containsAll(Arrays.asList("io.atlasmap.v2.Field", "io.atlasmap.v2.AtlasMapping", "io.atlasmap.v2.Action", "io.atlasmap.v2.Capitalize")));
    }

    @Test
    public void testGetUriDataType() {
        Assert.assertEquals((Object)"util", (Object)AtlasUtil.getUriDataType((String)"atlas:java:util?param1=value1&param2=value2"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFindClassesForPackageIllegalArgumentException() {
        AtlasUtil.findClassesForPackage((String)"io.atlasmapv2");
    }

    @Test
    public void testFind() {
        File file = Paths.get("src" + File.separator + "main" + File.separator + "java" + File.separator + "io" + File.separator + "atlasmap" + File.separator + "core", new String[0]).toFile();
        Assert.assertEquals((long)0L, (long)AtlasUtil.find((File)file, (String)".").size());
    }

    @Test
    public void testLoadPropertiesFromURL() throws Exception {
        URL url = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "AtlasUtilTest.properties", new String[0]).toUri().toURL();
        Properties properties = AtlasUtil.loadPropertiesFromURL((URL)url);
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((Object)"value1", (Object)properties.get("key1"));
        Assert.assertEquals((Object)"value2", (Object)properties.get("key2"));
    }

    @Test(expected=NullPointerException.class)
    public void testLoadPropertiesFromURLNullPointerException() throws Exception {
        AtlasUtil.loadPropertiesFromURL(null);
    }

    @Test(expected=MalformedURLException.class)
    public void testLoadPropertiesFromURLMalformedURLException() throws Exception {
        AtlasUtil.loadPropertiesFromURL((URL)new URL("invalid URL"));
    }

    @Test
    public void testMatchUriModule() {
        Assert.assertFalse((boolean)AtlasUtil.matchUriModule(null, null));
        Assert.assertFalse((boolean)AtlasUtil.matchUriModule(null, (String)"atlas:java"));
        Assert.assertFalse((boolean)AtlasUtil.matchUriModule((String)"atlas:java", null));
        Assert.assertFalse((boolean)AtlasUtil.matchUriModule((String)"", (String)""));
        Assert.assertFalse((boolean)AtlasUtil.matchUriModule((String)"atlas:java", (String)""));
        Assert.assertFalse((boolean)AtlasUtil.matchUriModule((String)"", (String)"atlas:java"));
        Assert.assertTrue((boolean)AtlasUtil.matchUriModule((String)"atlas:java", (String)"atlas:java"));
    }

    @Test(expected=IllegalStateException.class)
    public void testValidateUriIllegalStateException() {
        AtlasUtil.validateUri((String)"java:atlas");
    }

    @Test(expected=IllegalStateException.class)
    public void testValidateUriIllegalStateExceptionMultipleQuestionMark() {
        AtlasUtil.validateUri((String)"atlas:?java?");
    }

    @Test
    public void testValidateUriSingleQuestionMark() {
        AtlasUtil.validateUri((String)"atlas:java?");
    }

    @Test
    public void testValidateUri() {
        AtlasUtil.validateUri((String)"atlas:java");
    }

    @Test
    public void testGetUriPartsAsArray() {
        Assert.assertNull((Object)AtlasUtil.getUriPartsAsArray(null));
        Assert.assertEquals((long)2L, (long)AtlasUtil.getUriPartsAsArray((String)"atlas:?java").size());
        Assert.assertEquals((long)2L, (long)AtlasUtil.getUriPartsAsArray((String)"atlas:?").size());
        Assert.assertEquals((long)2L, (long)AtlasUtil.getUriPartsAsArray((String)"atlas:").size());
    }

    @Test
    public void testGetUriScheme() {
        Assert.assertNull((Object)AtlasUtil.getUriScheme(null));
    }

    @Test
    public void testGetUriParameters() {
        Assert.assertNull((Object)AtlasUtil.getUriParameters(null));
        Assert.assertEquals((long)0L, (long)AtlasUtil.getUriParameters((String)"").size());
        Assert.assertEquals((long)0L, (long)AtlasUtil.getUriParameters((String)"atlas:").size());
        Assert.assertEquals((long)0L, (long)AtlasUtil.getUriParameters((String)"atlas:?").size());
        Assert.assertEquals((long)2L, (long)AtlasUtil.getUriParameters((String)"atlas:?param1=value1&param2=value2").size());
        Assert.assertEquals((long)1L, (long)AtlasUtil.getUriParameters((String)"atlas:?param1=value1&param2=").size());
        Assert.assertEquals((long)1L, (long)AtlasUtil.getUriParameters((String)"atlas:?param1=&param2=value2").size());
        Assert.assertEquals((long)1L, (long)AtlasUtil.getUriParameters((String)"atlas:?=&param2=value2").size());
        Assert.assertEquals((long)0L, (long)AtlasUtil.getUriParameters((String)"atlas:?=").size());
        Assert.assertEquals((long)0L, (long)AtlasUtil.getUriParameters((String)"atlas:?&").size());
        Assert.assertEquals((long)0L, (long)AtlasUtil.getUriParameters((String)"atlas:?p").size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUriParametersIllegalArgumentException() {
        AtlasUtil.getUriParameters((String)"atlas:?%%XX");
    }

    @Test
    public void testGetUriParameterValue() {
        Assert.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?java", (String)"java"));
        Assert.assertEquals((Object)"value1", (Object)AtlasUtil.getUriParameterValue((String)"atlas:?param1=value1&param2=value2", (String)"param1"));
        Assert.assertEquals((Object)"value1", (Object)AtlasUtil.getUriParameterValue((String)"atlas:?param1=value1&param2=", (String)"param1"));
        Assert.assertEquals((Object)"value2", (Object)AtlasUtil.getUriParameterValue((String)"atlas:?param1=&param2=value2", (String)"param2"));
        Assert.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?", (String)"java"));
        Assert.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?param", (String)"java"));
        Assert.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?&", (String)"java"));
        Assert.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?=", (String)"java"));
        Assert.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:? ", (String)"java"));
    }

    @Test
    public void testFindClassesFromJar() throws Exception {
        URL jarFile = new File("target" + File.separator + "test-dependencies" + File.separator + "atlas-model.jar").toURI().toURL();
        String urlString = "jar:file:" + jarFile.getPath() + "!/";
        Assert.assertFalse((boolean)AtlasUtil.findClassesFromJar((URL)new URL(urlString)).isEmpty());
    }

    @Test
    public void testFindClassesFromJarFileNotFoundIOException() throws Exception {
        String urlString = "jar:file:" + File.separator + "target" + File.separator + "test-dependencies" + File.separator + "atlas-model.jar!/";
        Assert.assertEquals((long)0L, (long)AtlasUtil.findClassesFromJar((URL)new URL(urlString)).size());
    }

    @Test(expected=ClassCastException.class)
    public void testFindClassesFromJarClassCastException() throws Exception {
        URL url = Paths.get("target" + File.separator + "test-dependencies" + File.separator + "atlas-model.jar", new String[0]).toUri().toURL();
        AtlasUtil.findClassesFromJar((URL)url);
    }

    @Test
    public void testToAuditStatus() {
        Assert.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.ERROR));
        Assert.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.WARN));
        Assert.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.INFO));
        Assert.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.ALL));
        Assert.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.NONE));
    }
}

