/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.parsers;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.daffodil.infoset.DISimple;
import org.apache.daffodil.infoset.DataValue$;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.processors.ElementRuntimeData;
import org.apache.daffodil.processors.PrimProcessor;
import org.apache.daffodil.processors.Processor;
import org.apache.daffodil.processors.ToBriefXMLImpl;
import org.apache.daffodil.processors.parsers.PState;
import org.apache.daffodil.processors.parsers.Parser;
import org.apache.daffodil.processors.parsers.PrimParser;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import org.apache.daffodil.util.MaybeULong$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q2QAB\u0004\u0002\"IA\u0001\"\b\u0001\u0003\u0006\u0004%\tE\b\u0005\tG\u0001\u0011\t\u0011)A\u0005?!)A\u0005\u0001C\u0001K!)\u0001\u0006\u0001D\tS!)!\u0007\u0001C#g\t\u0001\"\t\\8c\u0019\u0016tw\r\u001e5QCJ\u001cXM\u001d\u0006\u0003\u0011%\tq\u0001]1sg\u0016\u00148O\u0003\u0002\u000b\u0017\u0005Q\u0001O]8dKN\u001cxN]:\u000b\u00051i\u0011\u0001\u00033bM\u001a|G-\u001b7\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\r\u00011#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iYR\"A\u0004\n\u0005q9!A\u0003)sS6\u0004\u0016M]:fe\u000691m\u001c8uKb$X#A\u0010\u0011\u0005\u0001\nS\"A\u0005\n\u0005\tJ!AE#mK6,g\u000e\u001e*v]RLW.\u001a#bi\u0006\f\u0001bY8oi\u0016DH\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0019:\u0003C\u0001\u000e\u0001\u0011\u0015i2\u00011\u0001 \u0003=9W\r\u001e'f]\u001e$\b.\u00138CSR\u001cHC\u0001\u0016.!\t!2&\u0003\u0002-+\t!Aj\u001c8h\u0011\u0015qC\u00011\u00010\u0003\u0019\u00018\u000f^1uKB\u0011!\u0004M\u0005\u0003c\u001d\u0011a\u0001U*uCR,\u0017!\u00029beN,GC\u0001\u001b8!\t!R'\u0003\u00027+\t!QK\\5u\u0011\u0015AT\u00011\u00010\u0003\u0015\u0019H/\u0019:uS\t\u0001!(\u0003\u0002<\u000f\tI\"\t\\8c'B,7-\u001b4jK\u0012dUM\\4uQB\u000b'o]3s\u0001")
public abstract class BlobLengthParser
implements PrimParser {
    private final ElementRuntimeData context;
    private String parserName;
    private boolean isInitialized;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    private volatile byte bitmap$0;

    @Override
    public boolean isEmpty() {
        return Parser.isEmpty$(this);
    }

    @Override
    public void PE(PState pstate, String s, Seq<Object> args) {
        Parser.PE$(this, pstate, s, args);
    }

    @Override
    public void PENotEnoughBits(PState pstate, long neededBits, long remainingBits) {
        Parser.PENotEnoughBits$(this, pstate, neededBits, remainingBits);
    }

    @Override
    public void processingError(PState state, String str, Seq<Object> args) {
        Parser.processingError$(this, state, str, args);
    }

    @Override
    public final void parse1(PState pstate) {
        Parser.parse1$(this, pstate);
    }

    @Override
    public Vector<Processor> childProcessors() {
        return PrimProcessor.childProcessors$(this);
    }

    @Override
    public boolean isPrimitive() {
        return PrimProcessor.isPrimitive$(this);
    }

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    @Override
    public String nom() {
        return ToBriefXMLImpl.nom$(this);
    }

    @Override
    public String briefXMLAttributes() {
        return ToBriefXMLImpl.briefXMLAttributes$(this);
    }

    @Override
    public String toBriefXML(int depthLimit) {
        return ToBriefXMLImpl.toBriefXML$(this, depthLimit);
    }

    @Override
    public int toBriefXML$default$1() {
        return ToBriefXMLImpl.toBriefXML$default$1$(this);
    }

    @Override
    public String toString() {
        return ToBriefXMLImpl.toString$(this);
    }

    private String parserName$lzycompute() {
        BlobLengthParser blobLengthParser = this;
        synchronized (blobLengthParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.parserName = Parser.parserName$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.parserName;
    }

    @Override
    public String parserName() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.parserName$lzycompute() : this.parserName;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    private String logID$lzycompute() {
        BlobLengthParser blobLengthParser = this;
        synchronized (blobLengthParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logID;
    }

    public String logID() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    private String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$lzycompute() {
        BlobLengthParser blobLengthParser = this;
        synchronized (blobLengthParser) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_ = ToBriefXMLImpl.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    }

    @Override
    public String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$lzycompute() : this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    public abstract long getLengthInBits(PState var1);

    @Override
    public final void parse(PState start) {
        Path path;
        InputSourceDataInputStream dis = start.dataInputStream();
        DISimple currentElement = start.simpleElement();
        long nBits = this.getLengthInBits(start);
        try {
            Path blobDir = start.output().getBlobDirectory();
            Files.createDirectories(blobDir, new FileAttribute[0]);
            path = Files.createTempFile(blobDir, start.output().getBlobPrefix(), start.output().getBlobSuffix(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw start.SDE("Unable to create blob file: ", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}));
        }
        Path blobPath = path;
        OutputStream blobStream = Files.newOutputStream(blobPath, StandardOpenOption.WRITE);
        long remainingBitsToGet = nBits;
        byte[] array = new byte[start.tunable().blobChunkSizeInBytes()];
        int blobChunkSizeInBits = start.tunable().blobChunkSizeInBytes() * 8;
        if (blobChunkSizeInBits > Integer.MAX_VALUE) {
            throw start.SDE(new StringBuilder(74).append("blobChunkSizeInBytes is too large. blobChunkSizeInBytes must be less than ").append(0xFFFFFFF).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        while (remainingBitsToGet > 0L) {
            long l;
            int bitsToGet = (int)Math.min(remainingBitsToGet, (long)blobChunkSizeInBits);
            if (dis.isDefinedForLength((long)bitsToGet)) {
                start.dataInputStream().getByteArray(bitsToGet, (FormatInfo)start, array);
                int bytesToPut = (bitsToGet + 7) / 8;
                blobStream.write(array, 0, bytesToPut);
                remainingBitsToGet -= (long)bitsToGet;
                continue;
            }
            if (MaybeULong$.MODULE$.isDefined$extension(dis.remainingBits())) {
                long totalBitsRead = nBits - remainingBitsToGet;
                l = MaybeULong$.MODULE$.apply(MaybeULong$.MODULE$.get$extension(dis.remainingBits()) + totalBitsRead);
            } else {
                l = MaybeULong$.MODULE$.Nope();
            }
            long remainingBits = l;
            this.PENotEnoughBits(start, nBits, remainingBits);
            remainingBitsToGet = 0L;
        }
        blobStream.close();
        if (start.isSuccess()) {
            currentElement.setDataValue(DataValue$.MODULE$.toDataValue(blobPath.toUri()));
            start.addBlobPath(blobPath);
        } else {
            Files.delete(blobPath);
        }
    }

    public BlobLengthParser(ElementRuntimeData context) {
        this.context = context;
        ToBriefXMLImpl.$init$(this);
        Logging.$init$((Logging)this);
        Processor.$init$(this);
        PrimProcessor.$init$(this);
        Parser.$init$(this);
    }
}

