/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors;

import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.processors.Suspension;
import org.apache.daffodil.processors.SuspensionDeadlockException;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0006\f\u0001?!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d9\u0004A1A\u0005\naBa\u0001\u0012\u0001!\u0002\u0013I\u0004bB#\u0001\u0005\u0004%I\u0001\u000f\u0005\u0007\r\u0002\u0001\u000b\u0011B\u001d\t\u000f\u001d\u0003\u0001\u0019!C\u0005\u0011\"9\u0011\n\u0001a\u0001\n\u0013Q\u0005B\u0002)\u0001A\u0003&Q\u0006C\u0004R\u0001\u0001\u0007I\u0011\u0002%\t\u000fI\u0003\u0001\u0019!C\u0005'\"1Q\u000b\u0001Q!\n5BqA\u0016\u0001A\u0002\u0013%\u0001\nC\u0004X\u0001\u0001\u0007I\u0011\u0002-\t\ri\u0003\u0001\u0015)\u0003.\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\t\u0007\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0005E\u0019Vo\u001d9f]NLwN\u001c+sC\u000e\\WM\u001d\u0006\u0003/a\t!\u0002\u001d:pG\u0016\u001c8o\u001c:t\u0015\tI\"$\u0001\u0005eC\u001a4w\u000eZ5m\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9#&D\u0001)\u0015\tI\u0003$\u0001\u0003vi&d\u0017BA\u0016)\u0005\u001daunZ4j]\u001e\f1c];ta\u0016t7/[8o/\u0006LG/W8v]\u001e\u0004\"!\t\u0018\n\u0005=\u0012#aA%oi\u0006\t2/^:qK:\u001c\u0018n\u001c8XC&$x\n\u001c3\u0002\rqJg.\u001b;?)\r\u0019TG\u000e\t\u0003i\u0001i\u0011A\u0006\u0005\u0006Y\r\u0001\r!\f\u0005\u0006a\r\u0001\r!L\u0001\u0011gV\u001c\b/\u001a8tS>t7/W8v]\u001e,\u0012!\u000f\t\u0004u}\nU\"A\u001e\u000b\u0005qj\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003}\t\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00015HA\u0003Rk\u0016,X\r\u0005\u00025\u0005&\u00111I\u0006\u0002\u000b'V\u001c\b/\u001a8tS>t\u0017!E:vgB,gn]5p]NLv.\u001e8hA\u0005q1/^:qK:\u001c\u0018n\u001c8t\u001f2$\u0017aD:vgB,gn]5p]N|E\u000e\u001a\u0011\u0002\u000b\r|WO\u001c;\u0016\u00035\n\u0011bY8v]R|F%Z9\u0015\u0005-s\u0005CA\u0011M\u0013\ti%E\u0001\u0003V]&$\bbB(\n\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0014AB2pk:$\b%A\u000btkN\u0004XM\\:j_:\u001cF/\u0019;Ue\u0006\u001c7.\u001a3\u00023M,8\u000f]3og&|gn\u0015;biR\u0013\u0018mY6fI~#S-\u001d\u000b\u0003\u0017RCqa\u0014\u0007\u0002\u0002\u0003\u0007Q&\u0001\ftkN\u0004XM\\:j_:\u001cF/\u0019;Ue\u0006\u001c7.\u001a3!\u0003I\u0019Xo\u001d9f]NLwN\\*uCR\u0014VO\\:\u0002-M,8\u000f]3og&|gn\u0015;biJ+hn]0%KF$\"aS-\t\u000f={\u0011\u0011!a\u0001[\u0005\u00192/^:qK:\u001c\u0018n\u001c8Ti\u0006$(+\u001e8tA\u0005yAO]1dWN+8\u000f]3og&|g\u000e\u0006\u0002L;\")a,\u0005a\u0001\u0003\u0006\t1/A\bfm\u0006d7+^:qK:\u001c\u0018n\u001c8t)\u0005Y\u0015\u0001\u0004:fcVL'/\u001a$j]\u0006d\u0017aE3wC2\u001cVo\u001d9f]NLwN\\)vKV,GCA&e\u0011\u0015)G\u00031\u0001:\u0003\u0015\tX/Z;f\u0001")
public class SuspensionTracker
implements Logging {
    private final int suspensionWaitYoung;
    private final int suspensionWaitOld;
    private final Queue<Suspension> suspensionsYoung;
    private final Queue<Suspension> suspensionsOld;
    private int count;
    private int suspensionStatTracked;
    private int suspensionStatRuns;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private volatile boolean bitmap$0;

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    private String logID$lzycompute() {
        SuspensionTracker suspensionTracker = this;
        synchronized (suspensionTracker) {
            if (!this.bitmap$0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logID;
    }

    public String logID() {
        return !this.bitmap$0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    private Queue<Suspension> suspensionsYoung() {
        return this.suspensionsYoung;
    }

    private Queue<Suspension> suspensionsOld() {
        return this.suspensionsOld;
    }

    private int count() {
        return this.count;
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
    }

    private int suspensionStatTracked() {
        return this.suspensionStatTracked;
    }

    private void suspensionStatTracked_$eq(int x$1) {
        this.suspensionStatTracked = x$1;
    }

    private int suspensionStatRuns() {
        return this.suspensionStatRuns;
    }

    private void suspensionStatRuns_$eq(int x$1) {
        this.suspensionStatRuns = x$1;
    }

    public void trackSuspension(Suspension s) {
        this.suspensionsYoung().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{s}));
        this.suspensionStatTracked_$eq(this.suspensionStatTracked() + 1);
    }

    public void evalSuspensions() {
        if (this.count() % this.suspensionWaitOld == 0) {
            this.evalSuspensionQueue(this.suspensionsOld());
        }
        if (this.count() % this.suspensionWaitYoung == 0) {
            this.evalSuspensionQueue(this.suspensionsYoung());
            while (this.suspensionsYoung().nonEmpty()) {
                this.suspensionsOld().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{(Suspension)this.suspensionsYoung().dequeue()}));
            }
        }
        if (this.count() == this.suspensionWaitOld) {
            this.count_$eq(0);
        } else {
            this.count_$eq(this.count() + 1);
        }
    }

    public void requireFinal() {
        BoxedUnit boxedUnit;
        while (this.suspensionsYoung().nonEmpty()) {
            this.suspensionsOld().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{(Suspension)this.suspensionsYoung().dequeue()}));
        }
        this.evalSuspensionQueue(this.suspensionsOld());
        if (this.suspensionsOld().length() == 1) {
            throw Assert$.MODULE$.abort(new StringBuilder(74).append("Invariant broken. ").append("Single suspended expression making no forward progress. ").append(this.suspensionsOld().apply(0)).toString());
        }
        if (this.suspensionsOld().nonEmpty()) {
            throw new SuspensionDeadlockException((Seq<Suspension>)this.suspensionsOld().seq());
        }
        LogLevel.Debug$ fresh$macro$1 = LogLevel.Debug$.MODULE$;
        int fresh$macro$2 = fresh$macro$1.lvl();
        if (this.getLoggingLevel().lvl() >= fresh$macro$2) {
            this.doLogging((LogLevel.Type)fresh$macro$1, "Suspension runs/tracked: %d/%d (%.2f%%)", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.suspensionStatRuns()), BoxesRunTime.boxToInteger((int)this.suspensionStatTracked()), BoxesRunTime.boxToFloat((float)((float)this.suspensionStatRuns() / (float)this.suspensionStatTracked() * (float)100))}))));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void evalSuspensionQueue(Queue<Suspension> queue) {
        int countOfNotMakingProgress = 0;
        while (!queue.isEmpty() && countOfNotMakingProgress < queue.length()) {
            Suspension s = (Suspension)queue.dequeue();
            this.suspensionStatRuns_$eq(this.suspensionStatRuns() + 1);
            s.runSuspension();
            if (!s.isDone()) {
                queue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{s}));
            }
            if (s.isDone() || s.isMakingProgress()) {
                countOfNotMakingProgress = 0;
                continue;
            }
            ++countOfNotMakingProgress;
        }
    }

    public SuspensionTracker(int suspensionWaitYoung, int suspensionWaitOld) {
        this.suspensionWaitYoung = suspensionWaitYoung;
        this.suspensionWaitOld = suspensionWaitOld;
        Logging.$init$((Logging)this);
        this.suspensionsYoung = new Queue();
        this.suspensionsOld = new Queue();
        this.count = 0;
        this.suspensionStatTracked = 0;
        this.suspensionStatRuns = 0;
    }
}

