/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;

public class NonNullValidator
implements AtlasValidator {
    private String violationMessage;
    private ValidationScope scope;

    public NonNullValidator(ValidationScope scope, String violationMessage) {
        this.scope = scope;
        this.violationMessage = violationMessage;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public void validate(Object target, List<Validation> validations, String id) {
        this.validate(target, validations, id, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, String id, ValidationStatus status) {
        String value;
        if (target == null) {
            Validation validation = new Validation();
            validation.setScope(this.scope);
            validation.setId(id);
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validations.add(validation);
        } else if (target.getClass().isAssignableFrom(String.class) && (value = (String)target).trim().isEmpty()) {
            Validation validation = new Validation();
            validation.setScope(this.scope);
            validation.setId(id);
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validations.add(validation);
        }
    }
}

