/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class LocalDateTimeConverter
implements AtlasConverter<LocalDateTime> {
    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(LocalDateTime value) {
        return value != null ? BigDecimal.valueOf(this.getEpochMilli(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(LocalDateTime value) {
        return value != null ? BigInteger.valueOf(this.getEpochMilli(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte toByte(LocalDateTime value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = this.getEpochMilli(value);
        if (longValue >= -128L && longValue <= 127L) {
            return longValue.byteValue();
        }
        throw new AtlasConversionException(String.format("LocalDateTime %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE", value));
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public Calendar toCalendar(LocalDateTime value) {
        return value != null ? GregorianCalendar.from(value.atZone(ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME)
    public java.util.Date toDate(LocalDateTime value) {
        return value != null ? new java.util.Date(this.getEpochMilli(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DOUBLE)
    public Double toDouble(LocalDateTime value) {
        return value != null ? Double.valueOf(this.getEpochMilli(value).doubleValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.FLOAT)
    public Float toFloat(LocalDateTime value) {
        return value != null ? Float.valueOf(this.getEpochMilli(value).floatValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public GregorianCalendar toGregorianCalendar(LocalDateTime value) {
        return value != null ? GregorianCalendar.from(value.atZone(ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer toInteger(LocalDateTime value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = this.getEpochMilli(value);
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw new AtlasConversionException(String.format("LocalDateTime %s is greater than Integer.MAX_VALUE or less than Integer.MIN_VALUE", value));
        }
        return longValue.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE)
    public LocalDate toLocalDate(LocalDateTime value) {
        return value != null ? value.toLocalDate() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(LocalDateTime value) {
        return value;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.TIME)
    public LocalTime toLocalTime(LocalDateTime value) {
        return value != null ? value.toLocalTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.LONG)
    public Long toLong(LocalDateTime value) {
        return value != null ? this.getEpochMilli(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short toShort(LocalDateTime value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = this.getEpochMilli(value);
        if (longValue > 32767L || longValue < -32768L) {
            throw new AtlasConversionException(String.format("LocalDateTime %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return longValue.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public String toString(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public CharBuffer toCharBuffer(LocalDateTime value) {
        return value != null ? CharBuffer.wrap(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public CharSequence toCharSequence(LocalDateTime value) {
        return value != null ? this.toString(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public StringBuffer toStringBuffer(LocalDateTime value) {
        return value != null ? new StringBuffer(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.STRING)
    public StringBuilder toStringBuilder(LocalDateTime value) {
        return value != null ? new StringBuilder(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.NUMBER)
    public Number toNumber(LocalDateTime value) {
        return value != null ? this.getEpochMilli(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE)
    public Date toSqlDate(LocalDateTime value) {
        return value != null ? Date.valueOf(value.toLocalDate()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.TIME)
    public Time toSqlTime(LocalDateTime value) {
        return value != null ? Time.valueOf(value.toLocalTime()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME)
    public Timestamp toSqlTimestamp(LocalDateTime value) {
        return value != null ? Timestamp.valueOf(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(LocalDateTime value) {
        return value != null ? value.atZone(ZoneId.systemDefault()) : null;
    }

    private Long getEpochMilli(LocalDateTime value) {
        return value.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

