/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.util;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.exceptions.UnsuppressableException;
import org.apache.daffodil.util.Glob$;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogLevel$Debug$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u00154Q!\u0003\u0006\u0002\u0002MAQA\u0007\u0001\u0005\u0002mAQA\b\u0001\u0007\u0012}Aq\u0001\r\u0001C\u0002\u0013E\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\u0006w\u0001!\t\u0002\u0010\u0005\u0006\u0005\u0002!\tb\u0011\u0005\u0006\u001f\u0002!\t\u0002\u0015\u0005\u0006%\u0002!\ta\u0015\u0002\n\u0019><wK]5uKJT!a\u0003\u0007\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u001b9\t\u0001\u0002Z1gM>$\u0017\u000e\u001c\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0015\u0005)qO]5uKR\u0011\u0001e\t\t\u0003+\u0005J!A\t\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\t\u0001\r!J\u0001\u0004[N<\u0007C\u0001\u0014.\u001d\t93\u0006\u0005\u0002)-5\t\u0011F\u0003\u0002+%\u00051AH]8pizJ!\u0001\f\f\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003YY\tA\u0002^:uC6\u0004hi\u001c:nCR,\u0012A\r\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001^3yi*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005A\u0019\u0016.\u001c9mK\u0012\u000bG/\u001a$pe6\fG/A\u0007ugR\fW\u000e\u001d$pe6\fG\u000fI\u0001\u0007iN$\u0018-\u001c9\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u001c\u0002\t1\fgnZ\u0005\u0003]}\na\u0001\u001d:fM&DHcA\u0013E\u001b\")QI\u0002a\u0001\r\u0006\u0019AN\u001e7\u0011\u0005\u001dSeBA\u000fI\u0013\tI%\"\u0001\u0005M_\u001edUM^3m\u0013\tYEJ\u0001\u0003UsB,'BA%\u000b\u0011\u0015qe\u00011\u0001&\u0003\u0015awnZ%E\u0003\u0019\u0019XO\u001a4jqR\u0011Q%\u0015\u0005\u0006\u001d\u001e\u0001\r!J\u0001\u0004Y><G#\u0002\u0011U+Z;\u0006\"B#\t\u0001\u00041\u0005\"\u0002(\t\u0001\u0004)\u0003\"\u0002\u0013\t\u0001\u0004)\u0003\"\u0002-\t\u0001\u0004I\u0016\u0001B1sON\u00042AW0c\u001d\tYVL\u0004\u0002)9&\tq#\u0003\u0002_-\u00059\u0001/Y2lC\u001e,\u0017B\u00011b\u0005\r\u0019V-\u001d\u0006\u0003=Z\u0001\"!F2\n\u0005\u00114\"aA!os\u0002")
public abstract class LogWriter {
    private final SimpleDateFormat tstampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS ");

    public abstract void write(String var1);

    public SimpleDateFormat tstampFormat() {
        return this.tstampFormat;
    }

    public String tstamp() {
        return this.tstampFormat().format(new Date());
    }

    public String prefix(LogLevel.Type lvl, String logID) {
        boolean areStamping = lvl.$less(LogLevel$Debug$.MODULE$);
        String pre = areStamping ? new StringBuilder(1).append(this.tstamp()).append(" ").toString() : "";
        return new StringBuilder(2).append(pre).append(logID).append(" ").append(lvl).append("[").toString();
    }

    public String suffix(String logID) {
        return "]";
    }

    public void log(LogLevel.Type lvl, String logID, String msg, Seq<Object> args) {
        try {
            String mess = Glob$.MODULE$.stringify(msg, args);
            String p = this.prefix(lvl, logID);
            String s = this.suffix(logID);
            this.write(new StringBuilder(0).append(p).append(mess).append(s).toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 instanceof UnsuppressableException) {
                UnsuppressableException unsuppressableException = (UnsuppressableException)throwable2;
                throw unsuppressableException;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                Tuple2 tuple2 = LogWriter.liftedTree1$1(exception, args);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String estring = (String)tuple2._1();
                Seq argStrings = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)estring, (Object)argStrings);
                Tuple2 tuple23 = tuple22;
                String estring2 = (String)tuple23._1();
                Seq argStrings2 = (Seq)tuple23._2();
                System.err.println(new StringBuilder(25).append("Exception while logging: ").append(estring2).toString());
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("msg='%s' args=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, argStrings2})));
                throw Assert$.MODULE$.abort("Exception while logging");
            }
            throw throwable;
        }
    }

    private static final Tuple2 liftedTree1$1(Exception x12$1, Seq args$1) {
        Tuple2 tuple2;
        try {
            tuple2 = new Tuple2((Object)x12$1.toString(), args$1.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 instanceof UnsuppressableException) {
                UnsuppressableException unsuppressableException = (UnsuppressableException)throwable2;
                throw unsuppressableException;
            }
            if (throwable2 == null) {
                throw throwable;
            }
            Tuple2 tuple22 = new Tuple2((Object)x12$1.getClass().getName(), (Object)Nil$.MODULE$);
            tuple2 = tuple22;
        }
        return tuple2;
    }
}

