/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

public class ManagerUtil {
    public static final char INTERNAL_ACTION_ID_DELIMITER = '#';
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte aB : b) {
            sb.append(hexChar[(aB & 0xF0) >>> 4]);
            sb.append(hexChar[aB & 0xF]);
        }
        return sb.toString();
    }

    public static String getInternalActionId(String actionId) {
        if (actionId == null) {
            return null;
        }
        int delimiterIndex = actionId.indexOf(35);
        if (delimiterIndex > 0) {
            return actionId.substring(0, delimiterIndex);
        }
        return null;
    }

    public static String stripInternalActionId(String actionId) {
        int delimiterIndex = actionId.indexOf(35);
        if (delimiterIndex > 0) {
            if (actionId.length() > delimiterIndex + 1) {
                return actionId.substring(delimiterIndex + 1);
            }
            return null;
        }
        return null;
    }

    public static String addInternalActionId(String actionId, String internalActionId) {
        if (actionId == null) {
            return internalActionId + '#';
        }
        return internalActionId + '#' + actionId;
    }
}

