/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.tls.TlsCloseable;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsPeer;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private volatile TlsCloseable closeHandle;

    public void cancel() throws IOException {
        TlsCloseable closeHandle = this.closeHandle;
        if (null != closeHandle) {
            closeHandle.close();
        }
    }

    public void notifyCloseHandle(TlsCloseable closeHandle) {
        this.closeHandle = closeHandle;
    }

    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    public void notifyHandshakeComplete() throws IOException {
    }
}

