/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ref;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.builder.ExpressionBuilder;

@org.apache.camel.spi.annotations.Language(value="ref")
public class RefLanguage
implements Language,
IsSingleton {
    public static Expression ref(Object value) {
        String ref = value.toString();
        return ExpressionBuilder.refExpression((String)ref);
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(final String expression) {
        final Expression exp = RefLanguage.ref(expression);
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Expression target = null;
                Object lookup = exp.evaluate(exchange, Object.class);
                if (lookup instanceof Expression) {
                    target = (Expression)lookup;
                } else if (lookup instanceof Predicate) {
                    target = PredicateToExpressionAdapter.toExpression((Predicate)((Predicate)lookup));
                }
                if (target != null) {
                    return target.evaluate(exchange, Object.class);
                }
                throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + expression);
            }

            public String toString() {
                return exp.toString();
            }
        };
    }

    public boolean isSingleton() {
        return true;
    }
}

