/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.ResourceResolver;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ResourceResolverSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultResourceResolvers {
    private DefaultResourceResolvers() {
    }

    @ResourceResolver(value="ref")
    public static class RefResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "ref";
        private static final Logger LOGGER = LoggerFactory.getLogger(RefResolver.class);

        public RefResolver() {
            super(SCHEME);
        }

        public Resource createResource(final String location) {
            final String key = this.getRemaining(location);
            final String val = (String)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)key, String.class);
            LOGGER.trace("Creating resource: {} from registry", (Object)key);
            return new Resource(){

                public String getLocation() {
                    return location;
                }

                public boolean exists() {
                    return val != null;
                }

                public InputStream getInputStream() throws IOException {
                    if (!this.exists()) {
                        throw new IOException("There is no bean in the registry with name " + key + "and type String");
                    }
                    return new ByteArrayInputStream(val.getBytes());
                }

                public String toString() {
                    return "Resource{location=" + this.getLocation() + '}';
                }
            };
        }
    }

    @ResourceResolver(value="classpath")
    public static class ClasspathResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "classpath";
        private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathResolver.class);

        public ClasspathResolver() {
            super(SCHEME);
        }

        public Resource createResource(final String location) {
            final String path = this.getPath(location);
            LOGGER.trace("Creating resource: {} from classpath", (Object)path);
            return new Resource(){

                public String getLocation() {
                    return location;
                }

                public boolean exists() {
                    return this.getURI() != null;
                }

                public URI getURI() {
                    URL url = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getClassResolver().loadResourceAsURL(path);
                    try {
                        return url != null ? url.toURI() : null;
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(e);
                    }
                }

                public InputStream getInputStream() throws IOException {
                    return ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getClassResolver().loadResourceAsStream(path);
                }

                public String toString() {
                    return "Resource{location=" + this.getLocation() + '}';
                }
            };
        }

        private String getPath(String location) {
            String uri = StringHelper.after((String)location, (String)"classpath:");
            uri = this.tryDecodeUri(uri);
            uri = FileUtil.compactPath((String)uri, (char)'/');
            return uri;
        }
    }

    @ResourceResolver(value="http")
    public static class HttpResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "http";
        private static final Logger LOGGER = LoggerFactory.getLogger(HttpResolver.class);

        public HttpResolver() {
            super(SCHEME);
        }

        public Resource createResource(final String location) {
            LOGGER.trace("Creating resource: {} from HTTP", (Object)location);
            return new Resource(){

                public String getLocation() {
                    return location;
                }

                public boolean exists() {
                    URLConnection connection = null;
                    try {
                        connection = new URL(location).openConnection();
                        if (connection instanceof HttpURLConnection) {
                            boolean bl = ((HttpURLConnection)connection).getResponseCode() == 200;
                            return bl;
                        }
                        boolean bl = connection.getContentLengthLong() > 0L;
                        return bl;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                    finally {
                        if (connection instanceof HttpURLConnection) {
                            ((HttpURLConnection)connection).disconnect();
                        }
                    }
                }

                public InputStream getInputStream() throws IOException {
                    URLConnection con = new URL(location).openConnection();
                    con.setUseCaches(false);
                    try {
                        return con.getInputStream();
                    }
                    catch (IOException e) {
                        if (con instanceof HttpURLConnection) {
                            ((HttpURLConnection)con).disconnect();
                        }
                        throw e;
                    }
                }

                public String toString() {
                    return "Resource{location=" + this.getLocation() + '}';
                }
            };
        }
    }

    @ResourceResolver(value="file")
    public static class FileResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "file";
        private static final Logger LOGGER = LoggerFactory.getLogger(FileResolver.class);

        public FileResolver() {
            super(SCHEME);
        }

        public Resource createResource(final String location) {
            String remaining = this.getRemaining(location);
            final Path path = Paths.get(this.tryDecodeUri(remaining), new String[0]);
            LOGGER.trace("Creating resource: {} from file system", (Object)path);
            return new Resource(){

                public String getLocation() {
                    return location;
                }

                public boolean exists() {
                    return Files.exists(path, new LinkOption[0]);
                }

                public URI getURI() {
                    return path.toUri();
                }

                public InputStream getInputStream() throws IOException {
                    if (!this.exists()) {
                        throw new FileNotFoundException(path.toString() + " does not exists");
                    }
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        throw new FileNotFoundException(path.toString() + " is a directory");
                    }
                    return Files.newInputStream(path, new OpenOption[0]);
                }

                public String toString() {
                    return "Resource{location=" + this.getLocation() + '}';
                }
            };
        }
    }
}

