/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.annotations.VPackDeserialize;
import com.arangodb.velocypack.annotations.VPackPOJOBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class VPackBuilderUtils {
    private final Map<CacheKey, BuilderInfo> cache = new ConcurrentHashMap<CacheKey, BuilderInfo>();

    public BuilderInfo getBuilderInfo(Type type, AnnotatedElement referencingElement) {
        if (type instanceof ParameterizedType) {
            return this.getBuilderInfo(((ParameterizedType)type).getRawType(), referencingElement);
        }
        if (type instanceof WildcardType) {
            return this.getBuilderInfo(((WildcardType)type).getUpperBounds()[0], referencingElement);
        }
        if (!(type instanceof Class)) {
            return null;
        }
        Class clazz = (Class)type;
        CacheKey key = new CacheKey(clazz, referencingElement);
        BuilderInfo fromCache = this.cache.get(key);
        if (fromCache != null) {
            return fromCache;
        }
        BuilderInfo builderInfo = this.getReferencingElementInfo(referencingElement);
        if (builderInfo == null) {
            builderInfo = this.getDeserializeClassInfo(clazz);
        }
        if (builderInfo == null) {
            builderInfo = this.getBuilderMethodInfo(clazz);
        }
        if (builderInfo == null) {
            builderInfo = this.getInnerBuilderInfo(clazz);
        }
        if (builderInfo == null) {
            return null;
        }
        if (builderInfo.annotation == null) {
            Class<?> builderClass = builderInfo.builderClass;
            BuilderInfo additionalBuilderInfo = this.getBuilderMethodInfo(builderClass);
            if (additionalBuilderInfo == null) {
                additionalBuilderInfo = this.getBuilderInfo(builderClass);
            }
            if (additionalBuilderInfo != null) {
                builderInfo = additionalBuilderInfo;
            }
        }
        if (builderInfo.annotation == null) {
            builderInfo.annotation = new VPackPOJOBuilder.Value();
        }
        this.cache.put(key, builderInfo);
        return builderInfo;
    }

    private BuilderInfo getBuilderMethodInfo(Class<?> clazz) {
        for (final Method method : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (!(annotation instanceof VPackPOJOBuilder)) continue;
                return new BuilderInfo(method.getReturnType(), this.mapVPackPOJOBuilder((VPackPOJOBuilder)annotation)){

                    @Override
                    public Object createBuilder() throws ReflectiveOperationException {
                        return method.invoke(null, new Object[0]);
                    }
                };
            }
        }
        return null;
    }

    private BuilderInfo getInnerBuilderInfo(Class<?> clazz) {
        for (final Class<?> innerClass : clazz.getDeclaredClasses()) {
            for (Annotation annotation : innerClass.getDeclaredAnnotations()) {
                if (!(annotation instanceof VPackPOJOBuilder)) continue;
                return new BuilderInfo(innerClass, this.mapVPackPOJOBuilder((VPackPOJOBuilder)annotation)){

                    @Override
                    public Object createBuilder() throws ReflectiveOperationException {
                        return innerClass.newInstance();
                    }
                };
            }
        }
        return null;
    }

    private BuilderInfo getBuilderInfo(final Class<?> clazz) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!(annotation instanceof VPackPOJOBuilder)) continue;
            return new BuilderInfo(clazz, this.mapVPackPOJOBuilder((VPackPOJOBuilder)annotation)){

                @Override
                public Object createBuilder() throws ReflectiveOperationException {
                    return clazz.newInstance();
                }
            };
        }
        return null;
    }

    private BuilderInfo getDeserializeClassInfo(Class<?> clazz) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!(annotation instanceof VPackDeserialize)) continue;
            final VPackDeserialize vPackDeserialize = (VPackDeserialize)annotation;
            return new BuilderInfo(vPackDeserialize.builder(), this.mapVPackPOJOBuilder(vPackDeserialize.builderConfig())){

                @Override
                public Object createBuilder() throws ReflectiveOperationException {
                    return vPackDeserialize.builder().newInstance();
                }
            };
        }
        return null;
    }

    private BuilderInfo getReferencingElementInfo(AnnotatedElement ref) {
        if (ref == null) {
            return null;
        }
        for (Annotation annotation : ref.getDeclaredAnnotations()) {
            if (!(annotation instanceof VPackDeserialize)) continue;
            final VPackDeserialize vPackDeserialize = (VPackDeserialize)annotation;
            return new BuilderInfo(vPackDeserialize.builder(), this.mapVPackPOJOBuilder(vPackDeserialize.builderConfig())){

                @Override
                public Object createBuilder() throws ReflectiveOperationException {
                    return vPackDeserialize.builder().newInstance();
                }
            };
        }
        return null;
    }

    private VPackPOJOBuilder.Value mapVPackPOJOBuilder(VPackPOJOBuilder annotation) {
        if (annotation.withSetterPrefix().equals("__UNDEFINED_WITH_PREFIX__") && annotation.buildMethodName().equals("__UNDEFINED_BUILD_METHOD_NAME__")) {
            return null;
        }
        return new VPackPOJOBuilder.Value(annotation);
    }

    private static class CacheKey {
        private final Type type;
        private final AnnotatedElement referencingElement;

        public CacheKey(Type type, AnnotatedElement referencingElement) {
            this.type = type;
            this.referencingElement = referencingElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.type, cacheKey.type) && Objects.equals(this.referencingElement, cacheKey.referencingElement);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.referencingElement);
        }
    }

    public static abstract class BuilderInfo {
        public Class<?> builderClass;
        public VPackPOJOBuilder.Value annotation;

        public BuilderInfo(Class<?> builderClass, VPackPOJOBuilder.Value annotation) {
            this.builderClass = builderClass;
            this.annotation = annotation;
        }

        public abstract Object createBuilder() throws ReflectiveOperationException;
    }
}

