/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.SliceIterator;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackKeyTypeException;
import com.arangodb.velocypack.exception.VPackNeedAttributeTranslatorException;
import com.arangodb.velocypack.exception.VPackValueTypeException;
import java.util.Map;
import java.util.NoSuchElementException;

public class ObjectIterator
extends SliceIterator<Map.Entry<String, VPackSlice>> {
    public ObjectIterator(VPackSlice slice) throws VPackValueTypeException {
        super(slice);
        if (!slice.isObject()) {
            throw new VPackValueTypeException(ValueType.OBJECT);
        }
        if (this.size > 0L) {
            byte head = slice.head();
            this.current = head == 20 ? (long)slice.keyAt(0).getStart() : (long)(slice.getStart() + slice.findDataOffset());
        }
    }

    @Override
    public Map.Entry<String, VPackSlice> next() {
        if (this.position++ > 0L) {
            if (this.position <= this.size && this.current != 0L) {
                this.current += (long)this.getCurrent().getByteSize();
                this.current += (long)this.getCurrent().getByteSize();
            } else {
                throw new NoSuchElementException();
            }
        }
        final VPackSlice currentField = this.getCurrent();
        return new Map.Entry<String, VPackSlice>(){

            @Override
            public VPackSlice setValue(VPackSlice value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VPackSlice getValue() {
                return new VPackSlice(currentField.getBuffer(), currentField.getStart() + currentField.getByteSize());
            }

            @Override
            public String getKey() {
                try {
                    return currentField.makeKey().getAsString();
                }
                catch (VPackKeyTypeException | VPackNeedAttributeTranslatorException e) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

