/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.arangodb.ArangoDbConfiguration;
import org.apache.camel.component.arangodb.ArangoDbEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="arangodb")
public class ArangoDbComponent
extends DefaultComponent {
    @Metadata
    private ArangoDbConfiguration configuration = new ArangoDbConfiguration();

    public ArangoDbComponent() {
        this(null);
    }

    public ArangoDbComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((Object)remaining)) {
            throw new IllegalArgumentException("Database name must be specified.");
        }
        ArangoDbConfiguration configuration = this.configuration != null ? this.configuration.copy() : new ArangoDbConfiguration();
        configuration.setDatabase(remaining);
        ArangoDbEndpoint endpoint = new ArangoDbEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public ArangoDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ArangoDbConfiguration configuration) {
        this.configuration = configuration;
    }
}

