/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class InternalArangoDB<E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    private static final String PATH_API_ADMIN_LOG = "/_admin/log";
    private static final String PATH_API_ADMIN_LOG_LEVEL = "/_admin/log/level";
    private static final String PATH_API_ROLE = "/_admin/server/role";
    private static final String PATH_ENDPOINTS = "/_api/cluster/endpoints";
    private static final String PATH_API_USER = "/_api/user";

    protected InternalArangoDB(E executor, ArangoSerializationFactory util, ArangoContext context) {
        super(executor, util, context);
    }

    protected Request getRoleRequest() {
        return this.request("_system", RequestType.GET, PATH_API_ROLE);
    }

    protected ArangoExecutor.ResponseDeserializer<ServerRole> getRoleResponseDeserializer() {
        return response -> (ServerRole)((Object)((Object)this.util().deserialize(response.getBody().get("role"), (java.lang.reflect.Type)((Object)ServerRole.class))));
    }

    protected Request createDatabaseRequest(DBCreateOptions options) {
        Request request = this.request("_system", RequestType.POST, "/_api/database");
        request.setBody(this.util().serialize(options));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Boolean> createDatabaseResponseDeserializer() {
        return response -> response.getBody().get("result").getAsBoolean();
    }

    protected Request getDatabasesRequest(String database) {
        return this.request(database, RequestType.GET, "/_api/database");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<String>>(){}.getType());
        };
    }

    protected Request getAccessibleDatabasesForRequest(String database, String user) {
        return this.request(database, RequestType.GET, PATH_API_USER, user, "database");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getAccessibleDatabasesForResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            ArrayList dbs = new ArrayList();
            Iterator iterator = result.objectIterator();
            while (iterator.hasNext()) {
                dbs.add(((Map.Entry)iterator.next()).getKey());
            }
            return dbs;
        };
    }

    protected Request createUserRequest(String database, String user, String passwd, UserCreateOptions options) {
        Request request = this.request(database, RequestType.POST, PATH_API_USER);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new UserCreateOptions(), user, passwd)));
        return request;
    }

    protected Request deleteUserRequest(String database, String user) {
        return this.request(database, RequestType.DELETE, PATH_API_USER, user);
    }

    protected Request getUsersRequest(String database) {
        return this.request(database, RequestType.GET, PATH_API_USER);
    }

    protected Request getUserRequest(String database, String user) {
        return this.request(database, RequestType.GET, PATH_API_USER, user);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<UserEntity>> getUsersResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result");
            return (Collection)this.util().deserialize(result, new Type<Collection<UserEntity>>(){}.getType());
        };
    }

    protected Request updateUserRequest(String database, String user, UserUpdateOptions options) {
        Request request = this.request(database, RequestType.PATCH, PATH_API_USER, user);
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request replaceUserRequest(String database, String user, UserUpdateOptions options) {
        Request request = this.request(database, RequestType.PUT, PATH_API_USER, user);
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request updateUserDefaultDatabaseAccessRequest(String user, Permissions permissions) {
        return this.request("_system", RequestType.PUT, PATH_API_USER, user, "database", "*").setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return this.request("_system", RequestType.PUT, PATH_API_USER, user, "database", "*", "*").setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request getLogsRequest(LogOptions options) {
        LogOptions params = options != null ? options : new LogOptions();
        return this.request("_system", RequestType.GET, PATH_API_ADMIN_LOG).putQueryParam("upto", (Object)params.getUpto()).putQueryParam("level", (Object)params.getLevel()).putQueryParam("start", params.getStart()).putQueryParam("size", params.getSize()).putQueryParam("offset", params.getOffset()).putQueryParam("search", params.getSearch()).putQueryParam("sort", (Object)params.getSort());
    }

    protected Request getLogLevelRequest() {
        return this.request("_system", RequestType.GET, PATH_API_ADMIN_LOG_LEVEL);
    }

    protected Request setLogLevelRequest(LogLevelEntity entity) {
        return this.request("_system", RequestType.PUT, PATH_API_ADMIN_LOG_LEVEL).setBody(this.util().serialize(entity));
    }
}

