/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.async.ArangoEdgeCollectionAsync;
import com.arangodb.async.ArangoGraphAsync;
import com.arangodb.async.ArangoVertexCollectionAsync;
import com.arangodb.async.internal.ArangoDBAsyncImpl;
import com.arangodb.async.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.async.internal.ArangoEdgeCollectionAsyncImpl;
import com.arangodb.async.internal.ArangoExecutorAsync;
import com.arangodb.async.internal.ArangoVertexCollectionAsyncImpl;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.model.GraphCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ArangoGraphAsyncImpl
extends InternalArangoGraph<ArangoDBAsyncImpl, ArangoDatabaseAsyncImpl, ArangoExecutorAsync>
implements ArangoGraphAsync {
    ArangoGraphAsyncImpl(ArangoDatabaseAsyncImpl db, String name) {
        super(db, name);
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(Objects::isNull);
    }

    @Override
    public CompletableFuture<GraphEntity> create(Collection<EdgeDefinition> edgeDefinitions) {
        return ((ArangoDatabaseAsyncImpl)this.db()).createGraph(this.name(), edgeDefinitions);
    }

    @Override
    public CompletableFuture<GraphEntity> createGraph(Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return ((ArangoDatabaseAsyncImpl)this.db()).createGraph(this.name(), edgeDefinitions, options);
    }

    @Override
    public CompletableFuture<Void> drop() {
        return ((ArangoExecutorAsync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> drop(boolean dropCollections) {
        return ((ArangoExecutorAsync)this.executor).execute(this.dropRequest(dropCollections), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<GraphEntity> getInfo() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getVertexCollections() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getVertexCollectionsRequest(), this.getVertexCollectionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> addVertexCollection(String name) {
        return ((ArangoExecutorAsync)this.executor).execute(this.addVertexCollectionRequest(name), this.addVertexCollectionResponseDeserializer());
    }

    @Override
    public ArangoVertexCollectionAsync vertexCollection(String name) {
        return new ArangoVertexCollectionAsyncImpl(this, name);
    }

    @Override
    public ArangoEdgeCollectionAsync edgeCollection(String name) {
        return new ArangoEdgeCollectionAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<Collection<String>> getEdgeDefinitions() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getEdgeDefinitionsRequest(), this.getEdgeDefinitionsDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> addEdgeDefinition(EdgeDefinition definition) {
        return ((ArangoExecutorAsync)this.executor).execute(this.addEdgeDefinitionRequest(definition), this.addEdgeDefinitionResponseDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> replaceEdgeDefinition(EdgeDefinition definition) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceEdgeDefinitionRequest(definition), this.replaceEdgeDefinitionResponseDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> removeEdgeDefinition(String definitionName) {
        return ((ArangoExecutorAsync)this.executor).execute(this.removeEdgeDefinitionRequest(definitionName), this.removeEdgeDefinitionResponseDeserializer());
    }
}

