/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal.util;

import com.arangodb.velocypack.internal.util.NumberUtil;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            return formatter;
        }
    };

    private DateUtil() {
    }

    public static Date toDate(byte[] array, int offset, int length) {
        long milliseconds = NumberUtil.toLong(array, offset, length);
        return new Date(milliseconds);
    }

    public static java.sql.Date toSQLDate(byte[] array, int offset, int length) {
        long milliseconds = NumberUtil.toLong(array, offset, length);
        return new java.sql.Date(milliseconds);
    }

    public static Timestamp toSQLTimestamp(byte[] array, int offset, int length) {
        long milliseconds = NumberUtil.toLong(array, offset, length);
        return new Timestamp(milliseconds);
    }

    public static Date parse(String source) throws ParseException {
        return DATE_FORMAT.get().parse(source);
    }

    public static String format(Date date) {
        return DATE_FORMAT.get().format(date);
    }
}

