/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSerializationContext;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.internal.util.DateUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.UUID;

public class VPackSerializers {
    public static final VPackSerializer<String> STRING = new VPackSerializer<String>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, String value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<Boolean> BOOLEAN = new VPackSerializer<Boolean>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Boolean value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<Integer> INTEGER = new VPackSerializer<Integer>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Integer value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<Long> LONG = new VPackSerializer<Long>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Long value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<Short> SHORT = new VPackSerializer<Short>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Short value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<Double> DOUBLE = new VPackSerializer<Double>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Double value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<Float> FLOAT = new VPackSerializer<Float>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Float value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<BigInteger> BIG_INTEGER = new VPackSerializer<BigInteger>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, BigInteger value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<BigDecimal> BIG_DECIMAL = new VPackSerializer<BigDecimal>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, BigDecimal value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<Number> NUMBER = new VPackSerializer<Number>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Number value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, (Double)value);
        }
    };
    public static final VPackSerializer<Character> CHARACTER = new VPackSerializer<Character>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Character value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<java.util.Date> DATE = new VPackSerializer<java.util.Date>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, java.util.Date value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, DateUtil.format(value));
        }
    };
    public static final VPackSerializer<Date> SQL_DATE = new VPackSerializer<Date>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Date value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, DateUtil.format(value));
        }
    };
    public static final VPackSerializer<Timestamp> SQL_TIMESTAMP = new VPackSerializer<Timestamp>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Timestamp value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, DateUtil.format(value));
        }
    };
    public static final VPackSerializer<VPackSlice> VPACK = new VPackSerializer<VPackSlice>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, VPackSlice value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value);
        }
    };
    public static final VPackSerializer<UUID> UUID = new VPackSerializer<UUID>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, UUID value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, value.toString());
        }
    };
    public static final VPackSerializer<byte[]> BYTE_ARRAY = new VPackSerializer<byte[]>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, byte[] value, VPackSerializationContext context) throws VPackException {
            builder.add(attribute, Base64.getEncoder().encodeToString(value));
        }
    };
    public static final VPackSerializer<Byte> BYTE = new VPackSerializer<Byte>(){

        @Override
        public void serialize(VPackBuilder builder, String attribute, Byte value, VPackSerializationContext context) {
            builder.add(attribute, value);
        }
    };

    private VPackSerializers() {
    }
}

