/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.util.HashMap;
import java.util.Map;

public abstract class InternalArangoRoute<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    protected final D db;
    protected final String path;
    protected final Map<String, String> queryParam;
    protected final Map<String, String> headerParam;
    protected Object body;

    protected InternalArangoRoute(D db, String path, Map<String, String> headerParam) {
        super(((InternalArangoDatabase)db).executor, ((InternalArangoDatabase)db).util, ((InternalArangoDatabase)db).context);
        this.db = db;
        this.path = path;
        this.queryParam = new HashMap<String, String>();
        this.headerParam = new HashMap<String, String>();
        this.headerParam.putAll(headerParam);
    }

    public void _withHeader(String key, Object value) {
        if (value != null) {
            this.headerParam.put(key, value.toString());
        }
    }

    public void _withQueryParam(String key, Object value) {
        if (value != null) {
            this.queryParam.put(key, value.toString());
        }
    }

    public void _withBody(Object body) {
        this.body = body;
    }

    protected Request createRequest(RequestType requestType) {
        Request request = this.request(((InternalArangoDatabase)this.db).name(), requestType, this.path);
        for (Map.Entry<String, String> param : this.headerParam.entrySet()) {
            request.putHeaderParam(param.getKey(), param.getValue());
        }
        for (Map.Entry<String, String> param : this.queryParam.entrySet()) {
            request.putQueryParam(param.getKey(), param.getValue());
        }
        if (this.body != null) {
            request.setBody(this.util().serialize(this.body));
        }
        return request;
    }
}

