/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.internal.AbstractApnsService;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.NetworkIOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchApnsService
extends AbstractApnsService {
    private static final Logger logger = LoggerFactory.getLogger(BatchApnsService.class);
    private int batchWaitTimeInSec = 5;
    private int maxBatchWaitTimeInSec = 10;
    private long firstMessageArrivedTime;
    private ApnsConnection prototype;
    private Queue<ApnsNotification> batch = new ConcurrentLinkedQueue<ApnsNotification>();
    private ScheduledExecutorService scheduleService;
    private ScheduledFuture<?> taskFuture;
    private Runnable batchRunner = new SendMessagesBatch();

    public BatchApnsService(ApnsConnection prototype, ApnsFeedbackConnection feedback, int batchWaitTimeInSec, int maxBachWaitTimeInSec, ThreadFactory tf) {
        super(feedback);
        this.prototype = prototype;
        this.batchWaitTimeInSec = batchWaitTimeInSec;
        this.maxBatchWaitTimeInSec = maxBachWaitTimeInSec;
        this.scheduleService = new ScheduledThreadPoolExecutor(1, tf == null ? Executors.defaultThreadFactory() : tf);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        Utilities.close(this.prototype);
        if (this.taskFuture != null) {
            this.taskFuture.cancel(true);
        }
        this.scheduleService.shutdownNow();
    }

    @Override
    public void testConnection() throws NetworkIOException {
        this.prototype.testConnection();
    }

    @Override
    public void push(ApnsNotification message) throws NetworkIOException {
        if (this.batch.isEmpty()) {
            this.firstMessageArrivedTime = System.nanoTime();
        }
        long sinceFirstMessageSec = (System.nanoTime() - this.firstMessageArrivedTime) / 1000L / 1000L / 1000L;
        if (this.taskFuture != null && sinceFirstMessageSec < (long)this.maxBatchWaitTimeInSec) {
            this.taskFuture.cancel(false);
        }
        this.batch.add(message);
        if (this.taskFuture == null || this.taskFuture.isDone()) {
            this.taskFuture = this.scheduleService.schedule(this.batchRunner, (long)this.batchWaitTimeInSec, TimeUnit.SECONDS);
        }
    }

    class SendMessagesBatch
    implements Runnable {
        SendMessagesBatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ApnsConnection newConnection = BatchApnsService.this.prototype.copy();
            try {
                ApnsNotification msg;
                while ((msg = (ApnsNotification)BatchApnsService.this.batch.poll()) != null) {
                    try {
                        newConnection.sendMessage(msg);
                    }
                    catch (NetworkIOException e) {
                        logger.warn("Network exception sending message msg " + msg.getIdentifier(), (Throwable)e);
                    }
                }
            }
            finally {
                Utilities.close(newConnection);
            }
        }
    }
}

