/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.TypeConversionException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.XMLRoutesDefinitionLoader;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JaxbXMLRoutesDefinitionLoader
implements XMLRoutesDefinitionLoader {
    public Object loadRoutesDefinition(CamelContext context, InputStream inputStream) throws Exception {
        RoutesDefinition answer;
        XmlConverter xmlConverter = JaxbXMLRoutesDefinitionLoader.newXmlConverter(context);
        Document dom = xmlConverter.toDOMDocument(inputStream, null);
        JAXBContext jaxbContext = JaxbXMLRoutesDefinitionLoader.getJAXBContext(context);
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        JaxbXMLRoutesDefinitionLoader.extractNamespaces(dom, namespaces);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to RoutesDefinition using JAXB");
        }
        if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            answer = new RoutesDefinition();
            JaxbXMLRoutesDefinitionLoader.applyNamespaces(route, namespaces);
            answer.getRoutes().add(route);
        } else if (result instanceof RoutesDefinition) {
            answer = (RoutesDefinition)result;
            for (RouteDefinition route : answer.getRoutes()) {
                JaxbXMLRoutesDefinitionLoader.applyNamespaces(route, namespaces);
            }
        } else {
            throw new IllegalArgumentException("Unmarshalled object is an unsupported type: " + ObjectHelper.className((Object)result) + " -> " + result);
        }
        return answer;
    }

    public Object loadRestsDefinition(CamelContext context, InputStream inputStream) throws Exception {
        RestsDefinition answer;
        Unmarshaller unmarshaller = JaxbXMLRoutesDefinitionLoader.getJAXBContext(context).createUnmarshaller();
        Object result = unmarshaller.unmarshal(inputStream);
        if (result == null) {
            throw new IOException("Cannot unmarshal to rests using JAXB from input stream: " + inputStream);
        }
        if (result instanceof RestDefinition) {
            RestDefinition rest = (RestDefinition)result;
            answer = new RestsDefinition();
            answer.getRests().add(rest);
        } else if (result instanceof RestsDefinition) {
            answer = (RestsDefinition)result;
        } else {
            throw new IllegalArgumentException("Unmarshalled object is an unsupported type: " + ObjectHelper.className((Object)result) + " -> " + result);
        }
        return answer;
    }

    public <T extends NamedNode> T createModelFromXml(CamelContext context, String xml, Class<T> type) throws Exception {
        return JaxbXMLRoutesDefinitionLoader.modelToXml(context, null, xml, type);
    }

    public String toString() {
        return "camel-xml-jaxb";
    }

    private static JAXBContext getJAXBContext(CamelContext context) throws JAXBException {
        ModelJAXBContextFactory factory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getModelJAXBContextFactory();
        return factory.newJAXBContext();
    }

    private static XmlConverter newXmlConverter(CamelContext context) {
        XmlConverter xmlConverter;
        if (context != null) {
            TypeConverterRegistry registry = context.getTypeConverterRegistry();
            xmlConverter = (XmlConverter)registry.getInjector().newInstance(XmlConverter.class, false);
        } else {
            xmlConverter = new XmlConverter();
        }
        return xmlConverter;
    }

    private static void extractNamespaces(Document document, Map<String, String> namespaces) throws JAXBException {
        NamedNodeMap attributes = document.getDocumentElement().getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            String nsPrefix = item.getNodeName();
            if (nsPrefix == null || !nsPrefix.startsWith("xmlns")) continue;
            String nsValue = item.getNodeValue();
            String[] nsParts = nsPrefix.split(":");
            if (nsParts.length == 1) {
                namespaces.put(nsParts[0], nsValue);
                continue;
            }
            if (nsParts.length == 2) {
                namespaces.put(nsParts[1], nsValue);
                continue;
            }
            namespaces.put(nsPrefix, nsValue);
        }
    }

    private static NamespaceAware getNamespaceAwareFromExpression(ExpressionNode expressionNode) {
        ExpressionDefinition ed = expressionNode.getExpression();
        NamespaceAware na = null;
        Expression exp = ed.getExpressionValue();
        if (exp instanceof NamespaceAware) {
            na = (NamespaceAware)exp;
        } else if (ed instanceof NamespaceAware) {
            na = (NamespaceAware)ed;
        }
        return na;
    }

    private static void applyNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Iterator it = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ExpressionNode.class);
        while (it.hasNext()) {
            NamespaceAware na = JaxbXMLRoutesDefinitionLoader.getNamespaceAwareFromExpression((ExpressionNode)it.next());
            if (na == null) continue;
            na.setNamespaces(namespaces);
        }
    }

    private static <T extends NamedNode> T modelToXml(CamelContext context, InputStream is, String xml, Class<T> type) throws Exception {
        JAXBContext jaxbContext = JaxbXMLRoutesDefinitionLoader.getJAXBContext(context);
        XmlConverter xmlConverter = JaxbXMLRoutesDefinitionLoader.newXmlConverter(context);
        Document dom = null;
        try {
            if (is != null) {
                dom = xmlConverter.toDOMDocument(is, null);
            } else if (xml != null) {
                dom = xmlConverter.toDOMDocument(xml, null);
            }
        }
        catch (Exception e) {
            throw new TypeConversionException((Object)xml, Document.class, (Throwable)e);
        }
        if (dom == null) {
            throw new IllegalArgumentException("InputStream and XML is both null");
        }
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        JaxbXMLRoutesDefinitionLoader.extractNamespaces(dom, namespaces);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to " + type + " using JAXB");
        }
        if (result instanceof RoutesDefinition) {
            List routes = ((RoutesDefinition)result).getRoutes();
            for (RouteDefinition route : routes) {
                JaxbXMLRoutesDefinitionLoader.applyNamespaces(route, namespaces);
            }
        } else if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            JaxbXMLRoutesDefinitionLoader.applyNamespaces(route, namespaces);
        }
        return (T)((NamedNode)type.cast(result));
    }
}

