/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.yaml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.k.RoutesLoader;
import org.apache.camel.k.Runtime;
import org.apache.camel.k.Source;
import org.apache.camel.k.support.URIResolver;
import org.apache.camel.k.yaml.model.Endpoint;
import org.apache.camel.k.yaml.model.Flow;
import org.apache.camel.k.yaml.model.Step;
import org.apache.camel.k.yaml.model.StepHandler;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.FactoryFinder;

public class YamlFlowLoader
implements RoutesLoader {
    private final ObjectMapper mapper;

    public YamlFlowLoader() {
        YAMLFactory yamlFactory = new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true).configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false);
        this.mapper = new ObjectMapper((JsonFactory)yamlFactory).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.registerSubtypes(new NamedType[]{new NamedType(Endpoint.class, "endpoint")});
    }

    public List<String> getSupportedLanguages() {
        return Collections.singletonList("flow");
    }

    public RouteBuilder load(Runtime.Registry registry, final Source source) throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                try (InputStream is = URIResolver.resolve((CamelContext)this.getContext(), (Source)source);){
                    for (Flow flow : (Flow[])YamlFlowLoader.this.mapper.readValue(is, Flow[].class)) {
                        List<Step> steps = flow.getSteps();
                        int size = steps.size();
                        FactoryFinder finder = this.getContext().getFactoryFinder("META-INF/services/org/apache/camel/k/yaml/flow/");
                        ProcessorDefinition<?> definition = null;
                        for (int i = 0; i < size; ++i) {
                            Step step = steps.get(i);
                            if (i == 0) {
                                definition = this.from(((Endpoint)step).getUri());
                                continue;
                            }
                            if (definition == null) {
                                throw new IllegalStateException("No route definition");
                            }
                            StepHandler handler = (StepHandler)finder.newInstance(step.getKind());
                            if (handler == null) {
                                throw new IllegalStateException("No handler for step with kind: " + step.getKind());
                            }
                            definition = handler.handle(step, definition);
                        }
                    }
                }
            }
        };
    }
}

