/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.health;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.ContextHealthCheck;
import org.apache.camel.impl.health.RoutesHealthCheckRepository;
import org.apache.camel.k.ContextCustomizer;
import org.apache.camel.k.inspector.InspectorCustomizer;

public class HealthContextCustomizer
implements ContextCustomizer {
    public static final String DEFAULT_PATH = "/health";
    private String path = "/health";
    private String healthGroupFilterExclude;
    private boolean includeRoutes = true;
    private boolean includeContext = true;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHealthGroupFilterExclude() {
        return this.healthGroupFilterExclude;
    }

    public void setHealthGroupFilterExclude(String healthGroupFilterExclude) {
        this.healthGroupFilterExclude = healthGroupFilterExclude;
    }

    public boolean isIncludeRoutes() {
        return this.includeRoutes;
    }

    public void setIncludeRoutes(boolean includeRoutes) {
        this.includeRoutes = includeRoutes;
    }

    public boolean isIncludeContext() {
        return this.includeContext;
    }

    public void setIncludeContext(boolean includeContext) {
        this.includeContext = includeContext;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void apply(CamelContext camelContext) {
        try {
            HealthCheckRegistry reg = HealthCheckRegistry.get((CamelContext)camelContext);
            if (this.includeRoutes) {
                reg.addRepository((HealthCheckRepository)new RoutesHealthCheckRepository());
            }
            if (this.includeContext) {
                ContextHealthCheck contextHealthCheck = new ContextHealthCheck();
                contextHealthCheck.getConfiguration().setEnabled(Boolean.valueOf(true));
                reg.register((HealthCheck)contextHealthCheck);
            }
            camelContext.addService((Object)reg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        camelContext.getRegistry().bind("health-route", (Object)this.customizer(camelContext));
    }

    private InspectorCustomizer customizer(CamelContext camelContext) {
        return router -> router.route(HttpMethod.GET, this.path).handler(routingContext -> {
            int code = 200;
            Collection results = HealthCheckHelper.invoke((CamelContext)camelContext, check -> check.getGroup() != null && check.getGroup().equals(this.getHealthGroupFilterExclude()));
            JsonObject response = new JsonObject();
            response.put("status", "UP");
            JsonArray checks = new JsonArray();
            for (HealthCheck.Result result : results) {
                Map details = result.getDetails();
                boolean enabled = true;
                if (details.containsKey("check.enabled")) {
                    enabled = (Boolean)details.get("check.enabled");
                }
                if (!enabled) continue;
                JsonObject check2 = new JsonObject();
                check2.put("name", result.getCheck().getId());
                check2.put("status", result.getState().name());
                if (result.getState() == HealthCheck.State.DOWN) {
                    response.put("status", "DOWN");
                    code = 503;
                }
                checks.add(check2);
            }
            if (!checks.isEmpty()) {
                response.put("checks", checks);
            }
            routingContext.response().putHeader("content-type", "application/json").setStatusCode(code).end(Json.encodePrettily((Object)response));
        });
    }
}

