/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.loader.js.quarkus.deployment;

import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.Consume;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.k.Source;
import org.apache.camel.k.Sources;
import org.apache.camel.k.loader.js.JavaScriptRoutesLoader;

@Path(value="/test")
@ApplicationScoped
public class Application {
    @Inject
    CamelContext context;

    @POST
    @Path(value="/load-routes/{name}")
    @Consume(value="text/plain")
    @Produces(value={"application/json"})
    public JsonObject loadRoutes(@PathParam(value="name") String name, String code) throws Exception {
        Source source = Sources.fromBytes((String)name, (String)"js", null, (byte[])code.getBytes(StandardCharsets.UTF_8));
        JavaScriptRoutesLoader loader = new JavaScriptRoutesLoader();
        RouteBuilder routes = loader.load(this.context, source);
        this.context.addRoutes((RoutesBuilder)routes);
        return Json.createObjectBuilder().add("components", this.extractComponents()).add("routes", this.extractRoutes()).add("endpoints", this.extractEndpoints()).build();
    }

    private JsonArrayBuilder extractComponents() {
        JsonArrayBuilder answer = Json.createArrayBuilder();
        this.context.getComponentNames().forEach(arg_0 -> ((JsonArrayBuilder)answer).add(arg_0));
        return answer;
    }

    private JsonArrayBuilder extractRoutes() {
        JsonArrayBuilder answer = Json.createArrayBuilder();
        this.context.getRoutes().forEach(r -> answer.add(r.getId()));
        return answer;
    }

    private JsonArrayBuilder extractEndpoints() {
        JsonArrayBuilder answer = Json.createArrayBuilder();
        this.context.getEndpoints().forEach(e -> answer.add(e.getEndpointUri()));
        return answer;
    }
}

