/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.loader.kotlin.dsl;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.annotations.KotlinScript;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.endpoint.EndpointBuilderFactory;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.k.loader.kotlin.KotlinCompilationConfiguration;
import org.apache.camel.k.loader.kotlin.dsl.BeansConfiguration;
import org.apache.camel.k.loader.kotlin.dsl.ContextConfiguration;
import org.apache.camel.k.loader.kotlin.dsl.RestConfiguration;
import org.apache.camel.k.loader.kotlin.dsl.Support;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.jetbrains.annotations.NotNull;

@KotlinScript(fileExtension="kts", compilationConfiguration=KotlinCompilationConfiguration.class)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u001f\u0010\u000f\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"J\u001f\u0010$\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/apache/camel/k/loader/kotlin/dsl/IntegrationConfiguration;", "Lorg/apache/camel/builder/BuilderSupport;", "Lorg/apache/camel/k/loader/kotlin/dsl/Support;", "Lorg/apache/camel/builder/endpoint/EndpointBuilderFactory;", "registry", "Lorg/apache/camel/spi/Registry;", "builder", "Lorg/apache/camel/builder/endpoint/EndpointRouteBuilder;", "(Lorg/apache/camel/spi/Registry;Lorg/apache/camel/builder/endpoint/EndpointRouteBuilder;)V", "beans", "", "block", "Lkotlin/Function1;", "Lorg/apache/camel/k/loader/kotlin/dsl/BeansConfiguration;", "Lkotlin/ExtensionFunctionType;", "context", "Lorg/apache/camel/k/loader/kotlin/dsl/ContextConfiguration;", "from", "Lorg/apache/camel/model/RouteDefinition;", "uri", "", "endpoint", "Lorg/apache/camel/builder/EndpointConsumerBuilder;", "intercept", "Lorg/apache/camel/model/InterceptDefinition;", "interceptFrom", "Lorg/apache/camel/model/InterceptFromDefinition;", "interceptSendToEndpoint", "Lorg/apache/camel/model/InterceptSendToEndpointDefinition;", "onCompletion", "Lorg/apache/camel/model/OnCompletionDefinition;", "onException", "Lorg/apache/camel/model/OnExceptionDefinition;", "exception", "Ljava/lang/Class;", "", "rest", "Lorg/apache/camel/k/loader/kotlin/dsl/RestConfiguration;", "camel-k-loader-kotlin"})
public abstract class IntegrationConfiguration
extends BuilderSupport
implements Support,
EndpointBuilderFactory {
    private final Registry registry;
    private final EndpointRouteBuilder builder;

    public final void rest(@NotNull Function1<? super RestConfiguration, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        block.invoke((Object)new RestConfiguration((RouteBuilder)this.builder));
    }

    public final void beans(@NotNull Function1<? super BeansConfiguration, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        CamelContext camelContext = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)camelContext, (String)"context");
        block.invoke((Object)new BeansConfiguration(camelContext));
    }

    public final void context(@NotNull Function1<? super ContextConfiguration, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        CamelContext camelContext = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)camelContext, (String)"context");
        Registry registry = this.registry;
        CamelContext camelContext2 = camelContext;
        block.invoke((Object)new ContextConfiguration(registry, camelContext2));
    }

    @NotNull
    public final RouteDefinition from(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        RouteDefinition routeDefinition = this.builder.from(uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)routeDefinition, (String)"builder.from(uri)");
        return routeDefinition;
    }

    @NotNull
    public final RouteDefinition from(@NotNull EndpointConsumerBuilder endpoint) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        RouteDefinition routeDefinition = this.builder.from(endpoint);
        Intrinsics.checkExpressionValueIsNotNull((Object)routeDefinition, (String)"builder.from(endpoint)");
        return routeDefinition;
    }

    @NotNull
    public final InterceptDefinition intercept() {
        InterceptDefinition interceptDefinition = this.builder.intercept();
        Intrinsics.checkExpressionValueIsNotNull((Object)interceptDefinition, (String)"builder.intercept()");
        return interceptDefinition;
    }

    @NotNull
    public final OnExceptionDefinition onException(@NotNull Class<? extends Throwable> exception) {
        Intrinsics.checkParameterIsNotNull(exception, (String)"exception");
        OnExceptionDefinition onExceptionDefinition = this.builder.onException(exception);
        Intrinsics.checkExpressionValueIsNotNull((Object)onExceptionDefinition, (String)"builder.onException(exception)");
        return onExceptionDefinition;
    }

    @NotNull
    public final OnCompletionDefinition onCompletion() {
        OnCompletionDefinition onCompletionDefinition = this.builder.onCompletion();
        Intrinsics.checkExpressionValueIsNotNull((Object)onCompletionDefinition, (String)"builder.onCompletion()");
        return onCompletionDefinition;
    }

    @NotNull
    public final InterceptFromDefinition interceptFrom() {
        InterceptFromDefinition interceptFromDefinition = this.builder.interceptFrom();
        Intrinsics.checkExpressionValueIsNotNull((Object)interceptFromDefinition, (String)"builder.interceptFrom()");
        return interceptFromDefinition;
    }

    @NotNull
    public final InterceptFromDefinition interceptFrom(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        InterceptFromDefinition interceptFromDefinition = this.builder.interceptFrom(uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)interceptFromDefinition, (String)"builder.interceptFrom(uri)");
        return interceptFromDefinition;
    }

    @NotNull
    public final InterceptSendToEndpointDefinition interceptSendToEndpoint(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        InterceptSendToEndpointDefinition interceptSendToEndpointDefinition = this.builder.interceptSendToEndpoint(uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)interceptSendToEndpointDefinition, (String)"builder.interceptSendToEndpoint(uri)");
        return interceptSendToEndpointDefinition;
    }

    public IntegrationConfiguration(@NotNull Registry registry, @NotNull EndpointRouteBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        super(builder.getContext());
        this.registry = registry;
        this.builder = builder;
    }

    @Override
    @NotNull
    public Processor processor(@NotNull Function1<? super Exchange, Unit> fn) {
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        return Support.DefaultImpls.processor(this, fn);
    }

    @Override
    @NotNull
    public Predicate predicate(@NotNull Function1<? super Exchange, Boolean> fn) {
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        return Support.DefaultImpls.predicate(this, fn);
    }
}

