/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.loader.java;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.k.RoutesLoader;
import org.apache.camel.k.Source;
import org.apache.camel.k.support.URIResolver;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joor.Reflect;

public class JavaSourceRoutesLoader
implements RoutesLoader {
    public List<String> getSupportedLanguages() {
        return Collections.singletonList("java");
    }

    public RouteBuilder load(CamelContext camelContext, Source source) throws Exception {
        try (InputStream is = URIResolver.resolve((CamelContext)camelContext, (Source)source);){
            RouteBuilder rb;
            String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String name = JavaSourceRoutesLoader.determineQualifiedName(source, content);
            Reflect compiled = Reflect.compile((String)name, (String)content);
            RouteBuilder routeBuilder = rb = (RouteBuilder)compiled.create().get();
            return routeBuilder;
        }
    }

    private static String determineQualifiedName(Source source, String content) throws Exception {
        String name = source.getName();
        name = StringUtils.removeEnd((String)name, (String)".java");
        Pattern pattern = Pattern.compile("^\\s*package\\s+([a-zA_Z_][\\.\\w]*)\\s*;.*");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            name = matcher.group(1) + "." + name;
        }
        return name;
    }
}

